/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.Comparator;
import tesseract.api.ConnectionType;
import tesseract.api.IConnectable;
import tesseract.graph.Path;

public abstract class Consumer<C extends IConnectable, N> {
    protected final N node;
    protected final ConnectionType connection;
    protected Long2ObjectMap<C> full = Long2ObjectMaps.emptyMap();
    protected Long2ObjectMap<C> cross = Long2ObjectMaps.emptyMap();
    protected int distance;
    public static final Comparator<Consumer<?, ?>> COMPARATOR = (t1, t2) -> t1.getPriority() == 0 && t2.getPriority() == 0 ? Integer.compare(t1.getDistance(), t2.getDistance()) : Integer.compare(t2.getPriority(), t1.getPriority());

    protected Consumer(N node, N producer, Path<C> path) {
        this.node = node;
        if (path != null) {
            this.full = path.getFull();
            this.cross = path.getCross();
        }
        int fullSize = this.full.size();
        int crossSize = this.cross.size();
        this.connection = crossSize == 0 ? (fullSize == 0 ? ConnectionType.ADJACENT : ConnectionType.SINGLE) : ConnectionType.VARIATE;
    }

    public void init() {
        if (this.full != null) {
            this.distance = this.full.size();
            for (Long2ObjectMap.Entry tuple : this.full.long2ObjectEntrySet()) {
                this.onConnectorCatch(tuple.getLongKey(), (IConnectable)tuple.getValue());
            }
        }
    }

    public N getNode() {
        return this.node;
    }

    public int getDistance() {
        return this.distance;
    }

    public ConnectionType getConnection() {
        return this.connection;
    }

    public Long2ObjectMap<C> getCross() {
        return this.cross;
    }

    public Long2ObjectMap<C> getFull() {
        return this.full;
    }

    protected abstract void onConnectorCatch(long var1, C var3);

    protected abstract int getPriority();
}

