/*
 * Decompiled with CFR 0.152.
 */
package tesseract;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TesseractConfig {
    public static final Common COMMON = new Common();
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void onModConfigEvent(ModConfig e) {
        if (e.getModId().equals("tesseractapi") && e.getSpec() == COMMON_SPEC) {
            TesseractConfig.bakeCommonConfig();
        }
    }

    private static void bakeCommonConfig() {
        TesseractConfig.COMMON.EU_TO_FE_RATIO = (Double)TesseractConfig.COMMON_CONFIG.EU_TO_FE_RATIO.get();
        TesseractConfig.COMMON.EU_TO_TRE_RATIO = (Double)TesseractConfig.COMMON_CONFIG.EU_TO_TRE_RATIO.get();
        TesseractConfig.COMMON.ENABLE_FE_OR_TRE_INPUT = (Boolean)TesseractConfig.COMMON_CONFIG.ENABLE_FE_OR_TRE_INPUT.get();
        TesseractConfig.COMMON.ENABLE_MI_COMPAT = (Boolean)TesseractConfig.COMMON_CONFIG.ENABLE_MI_COMPAT.get();
    }

    static {
        Pair COMMON_PAIR = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG = (CommonConfig)COMMON_PAIR.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)COMMON_PAIR.getRight();
    }

    public static class Common {
        public double EU_TO_FE_RATIO;
        public double EU_TO_TRE_RATIO;
        public boolean ENABLE_FE_OR_TRE_INPUT;
        public boolean ENABLE_MI_COMPAT;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.DoubleValue EU_TO_FE_RATIO;
        public final ForgeConfigSpec.DoubleValue EU_TO_TRE_RATIO;
        public final ForgeConfigSpec.BooleanValue ENABLE_FE_OR_TRE_INPUT;
        public final ForgeConfigSpec.BooleanValue ENABLE_MI_COMPAT;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.EU_TO_FE_RATIO = builder.comment("The ratio of the eu to the fe energy converting - Default: (1.0 EU = 8.0 FE)").translation("tesseractapi.config.eu_to_fe_ratio").defineInRange("EU_TO_FE_RATIO", 8.0, 0.1, Double.MAX_VALUE);
            this.EU_TO_TRE_RATIO = builder.comment("The ratio of the eu to the tre energy converting - Default: (1.0 EU = 1.0 TRE)").translation("tesseractapi.config.eu_to_tre_ratio").defineInRange("EU_TO_TRE_RATIO", 1.0, 0.1, Double.MAX_VALUE);
            this.ENABLE_FE_OR_TRE_INPUT = builder.comment(new String[]{"Enables GT Machines and  cables being able to input FE or TRE(Tech Reborn Energy),", "Please do not enable unless you have balanced the fe compat to not be broken due to power creep. - Default: false"}).translation("tesseractapi.config.enable_fe_or_tre_input").define("ENABLE_FE_OR_TRE_INPUT", false);
            this.ENABLE_MI_COMPAT = builder.comment("Enables Tesseract energy having compat with MI energy. - Default: false").translation("tesseractapi.config.enable_mi_compat").define("ENABLE_MI_COMPAT", true);
        }
    }
}

