/*
 * Decompiled with CFR 0.152.
 */
package tesseract;

import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import tesseract.TesseractCapUtils;
import tesseract.forge.FluidPlatformUtilsImpl;

public class FluidPlatformUtils {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FluidStack createFluidStack(Fluid fluid, long amount) {
        void var1_1;
        return FluidPlatformUtilsImpl.createFluidStack(fluid, (long)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getStillTexture(Fluid fluid) {
        return FluidPlatformUtilsImpl.getStillTexture(fluid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getFlowingTexture(Fluid fluid) {
        return FluidPlatformUtilsImpl.getFlowingTexture(fluid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceLocation getFluidId(Fluid fluid) {
        return FluidPlatformUtilsImpl.getFluidId(fluid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidTemperature(Fluid fluid) {
        return FluidPlatformUtilsImpl.getFluidTemperature(fluid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFluidGaseous(Fluid fluid) {
        return FluidPlatformUtilsImpl.isFluidGaseous(fluid);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFluidColor(Fluid fluid) {
        return FluidPlatformUtilsImpl.getFluidColor(fluid);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SoundEvent getFluidSound(Fluid fluid, boolean fill) {
        void var1_1;
        return FluidPlatformUtilsImpl.getFluidSound(fluid, (boolean)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Component getFluidDisplayName(FluidStack fluid) {
        return FluidPlatformUtilsImpl.getFluidDisplayName(fluid);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, long maxAmount, boolean doTransfer) {
        void var4_3;
        void var2_2;
        void var1_1;
        return FluidPlatformUtilsImpl.tryFluidTransfer(fluidDestination, (IFluidHandler)var1_1, (long)var2_2, (boolean)var4_3);
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull ItemStack container, IFluidHandler fluidSource, long maxAmount, @Nullable Player player, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return TesseractCapUtils.getFluidHandlerItem(containerCopy).map(containerFluidHandler -> {
            long realMaxAmount = maxAmount == -1L ? containerFluidHandler.getTankCapacityInDroplets(0) : maxAmount;
            FluidStack simulatedTransfer = FluidPlatformUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, realMaxAmount, false);
            if (!simulatedTransfer.isEmpty()) {
                if (doFill) {
                    FluidPlatformUtils.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, realMaxAmount, true);
                    if (player != null) {
                        SoundEvent soundevent = FluidPlatformUtils.getFluidSound(simulatedTransfer.getFluid(), true);
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    containerFluidHandler.fillDroplets(simulatedTransfer, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, long maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return TesseractCapUtils.getFluidHandlerItem(containerCopy).map(containerFluidHandler -> {
            long realMaxAmount = maxAmount == -1L ? containerFluidHandler.getTankCapacityInDroplets(0) : maxAmount;
            FluidStack transfer = FluidPlatformUtils.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, realMaxAmount, doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null) {
                SoundEvent soundevent = FluidPlatformUtils.getFluidSound(transfer.getFluid(), false);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                containerFluidHandler.drain(transfer.getRealAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }
}

