/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.client.hud;

import com.ewyboy.worldstripper.workers.StripWorker;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProgressBar {
    private static final ResourceLocation BAR_TEXTURE_1 = new ResourceLocation("textures/block/red_concrete.png");
    private static final ResourceLocation BAR_TEXTURE_2 = new ResourceLocation("textures/block/yellow_concrete.png");
    private static final ResourceLocation BAR_TEXTURE_3 = new ResourceLocation("textures/block/lime_concrete.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/block/gray_concrete.png");
    private static final ResourceLocation BAR_BACKGROUND_TEXTURE = new ResourceLocation("textures/block/white_concrete.png");

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.init(event.getMatrixStack());
        }
    }

    public void init(PoseStack stack) {
        float percent = StripWorker.getProgress();
        if (percent == 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        percent = Math.round(percent);
        double gui = mc.m_91268_().m_85449_();
        int guiWidth = mc.m_91268_().m_85445_();
        int guiHeight = mc.m_91268_().m_85446_();
        int width = (int)(((double)guiWidth * gui + 1.0) / (10.0 + gui + 1.0));
        int height = (int)((double)((int)((double)guiHeight * gui / (10.0 + gui))) / 4.5);
        int centerX = mc.m_91268_().m_85445_() / 2;
        int centerY = mc.m_91268_().m_85446_() / 2;
        String text = (int)percent + " / 100%";
        int textX = centerX - mc.f_91062_.m_92895_(text) / 2;
        Objects.requireNonNull(mc.f_91062_);
        int textY = centerY - 9 / 2;
        int startX = centerX - width;
        int stopX = centerX + width;
        int startY = centerY - height;
        int stopY = centerY + height;
        ProgressBar.draw(startX, startY, stopX, stopY, BACKGROUND_TEXTURE);
        ProgressBar.draw(startX + 2, startY + 2, stopX - 2, stopY - 2, BAR_BACKGROUND_TEXTURE);
        ProgressBar.draw(startX + 2, startY + 2, this.getProgressBarWidth(startX, percent, width) - 2, stopY - 2, this.getBarTexture(percent));
        mc.f_91062_.m_92883_(stack, percent + " / 100%", (float)textX, (float)textY, -14606047);
        if (percent >= 100.0f) {
            StripWorker.setProgress(0.0f);
        }
    }

    private ResourceLocation getBarTexture(float percent) {
        if (percent < 33.33f) {
            return BAR_TEXTURE_1;
        }
        if (percent < 66.66f) {
            return BAR_TEXTURE_2;
        }
        return BAR_TEXTURE_3;
    }

    private int getProgressBarWidth(int start, float percent, int maxWidth) {
        return (int)((double)start + (double)(percent / 100.0f * (float)maxWidth * 2.0f));
    }

    private static void draw(int startX, int startY, int endX, int endY, ResourceLocation texture) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Objects.requireNonNull(Minecraft.m_91087_()).m_91097_().m_118506_(texture);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_5483_((double)startX, (double)endY, 0.0).m_7421_((float)startX / 32.0f, (float)endY / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
        buffer.m_5483_((double)endX, (double)endY, 0.0).m_7421_((float)endX / 32.0f, (float)endY / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
        buffer.m_5483_((double)endX, (double)startY, 0.0).m_7421_((float)endX / 32.0f, (float)startY / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
        buffer.m_5483_((double)startX, (double)startY, 0.0).m_7421_((float)startX / 32.0f, (float)startY / 32.0f).m_6122_(255, 255, 255, 255).m_5752_();
        tesselator.m_85914_();
    }
}

