/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.worldstripper.client;

import com.ewyboy.worldstripper.network.MessageHandler;
import com.ewyboy.worldstripper.network.messages.MessageAddBlock;
import com.ewyboy.worldstripper.network.messages.MessageDressWorker;
import com.ewyboy.worldstripper.network.messages.MessageRemoveBlock;
import com.ewyboy.worldstripper.network.messages.MessageStripWorker;
import com.ewyboy.worldstripper.settings.Settings;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Keybindings {
    private static KeyMapping strip;
    private static KeyMapping dress;
    private static KeyMapping add;
    private static KeyMapping remove;
    private static KeyMapping increase;
    private static KeyMapping decrease;
    private static KeyMapping increaseBig;
    private static KeyMapping decreaseBig;

    public static void setup() {
        Keybindings.initKeyBinding();
        Keybindings.clickEvent();
    }

    public static void initKeyBinding() {
        strip = new KeyMapping("key.worldstripper.strip_world", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 261, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)strip);
        dress = new KeyMapping("key.worldstripper.dress_world", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 260, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)dress);
        add = new KeyMapping("key.worldstripper.add_block", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 266, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)add);
        remove = new KeyMapping("key.worldstripper.remove_block", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 267, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)remove);
        increase = new KeyMapping("key.worldstripper.increase_range", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, InputConstants.Type.KEYSYM, 266, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)increase);
        decrease = new KeyMapping("key.worldstripper.decrease_range", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, InputConstants.Type.KEYSYM, 267, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)decrease);
        increaseBig = new KeyMapping("key.worldstripper.big_increase_range", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 266, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)increaseBig);
        decreaseBig = new KeyMapping("key.worldstripper.big_decrease_range", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 267, "World Stripper");
        ClientRegistry.registerKeyBinding((KeyMapping)decreaseBig);
    }

    private static void clickEvent() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, Keybindings::onKeyInput);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (strip.m_90859_()) {
            MessageHandler.CHANNEL.sendToServer((Object)new MessageStripWorker());
        }
        if (dress.m_90859_()) {
            MessageHandler.CHANNEL.sendToServer((Object)new MessageDressWorker());
        }
        if (add.m_90859_()) {
            MessageHandler.CHANNEL.sendToServer((Object)new MessageAddBlock());
        }
        if (remove.m_90859_()) {
            MessageHandler.CHANNEL.sendToServer((Object)new MessageRemoveBlock());
        }
        if (increase.m_90859_()) {
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusX, 1);
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusZ, 1);
        }
        if (decrease.m_90859_()) {
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusX, -1);
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusZ, -1);
        }
        if (increaseBig.m_90859_()) {
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusX, 8);
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusZ, 8);
        }
        if (decreaseBig.m_90859_()) {
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusX, -8);
            Keybindings.bumpRange(Settings.SETTINGS.stripRadiusZ, -8);
        }
    }

    private static void bumpRange(ForgeConfigSpec.ConfigValue<Integer> setting, int change) {
        setting.set((Object)((Integer)setting.get() + change));
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent(ChatFormatting.AQUA + (String)setting.getPath().get(1) + ChatFormatting.WHITE + " is now set to " + ChatFormatting.LIGHT_PURPLE + setting.get()), Minecraft.m_91087_().f_91074_.m_142081_());
        }
    }
}

