/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CSyncBarrelStacks {
    private final int dimension;
    private final BlockPos pos;
    private final NonNullList<ItemStack> topStacks;

    public S2CSyncBarrelStacks(int dimension, BlockPos pos, NonNullList<ItemStack> topStacks) {
        this.dimension = dimension;
        this.pos = pos;
        this.topStacks = topStacks;
    }

    public static void encode(S2CSyncBarrelStacks msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.dimension);
        buf.writeInt(msg.pos.m_123341_());
        buf.writeInt(msg.pos.m_123342_());
        buf.writeInt(msg.pos.m_123343_());
        buf.writeInt(msg.topStacks.size());
        for (ItemStack stack : msg.topStacks) {
            buf.m_130055_(stack);
        }
    }

    public static S2CSyncBarrelStacks decode(FriendlyByteBuf buf) {
        int dimension = buf.readInt();
        BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        NonNullList topStacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int item = 0; item < size; ++item) {
            ItemStack itemStack = buf.m_130267_();
            topStacks.set(item, (Object)itemStack);
        }
        return new S2CSyncBarrelStacks(dimension, pos, (NonNullList<ItemStack>)topStacks);
    }

    public static class Handler {
        public static void handle(S2CSyncBarrelStacks message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Level world = (Level)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91073_);
                if (world != null) {
                    BlockEntity blockEntity = world.m_7702_(message.pos);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

