/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.item;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;

public class UpgradeInfo {
    private final List<TagKey<Block>> start_blocks;
    private final List<Block> end_blocks;

    public UpgradeInfo(List<TagKey<Block>> start_blocks, List<Block> end_blocks) {
        this.start_blocks = start_blocks;
        this.end_blocks = end_blocks;
    }

    public int getIndex(BlockState barrel) {
        for (int i = 0; i < this.start_blocks.size(); ++i) {
            if (!barrel.m_204336_(this.start_blocks.get(i))) continue;
            return i;
        }
        throw new IllegalArgumentException(barrel + " is not valid for upgrading!");
    }

    public Block getBlock(BlockState toUpgrade) {
        return this.end_blocks.get(this.getIndex(toUpgrade));
    }

    public UpgradeInfo add(TagKey<Block> start, Block end, String modid) {
        if (ModList.get().isLoaded(modid)) {
            this.start_blocks.add(start);
            this.end_blocks.add(end);
        }
        return this;
    }

    public boolean canUpgrade(BlockState barrel) {
        return IntStream.range(0, this.start_blocks.size()).anyMatch(i -> barrel.m_204336_(this.start_blocks.get(i)));
    }
}

