/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vein.old;

import java.util.ArrayList;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinBuilder;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinVariant;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinVariantMaterial;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinVariantMaterialBuilder;

public class WorldGenVeinVariantBuilder {
    private final WorldGenVeinBuilder veinBuilder;
    @Nullable
    private Integer weight;
    @Nullable
    private Float oreChance;
    @Nullable
    private Float smallOreChance;
    @Nullable
    private Float markerOreChance;
    @Nullable
    private Float surfaceStoneChance;
    private final ArrayList<WorldGenVeinVariantMaterial> materials;

    public WorldGenVeinVariantBuilder(WorldGenVeinBuilder veinBuilder) {
        this.veinBuilder = veinBuilder;
        this.materials = new ArrayList();
    }

    public final WorldGenVeinBuilder buildVariant() {
        if (this.weight == null) {
            throw new RuntimeException("weight is required");
        }
        if (this.materials.size() > 0 && this.oreChance == null && this.smallOreChance == null) {
            throw new RuntimeException("oreChance and/or smallOreChance is required when materials are specified");
        }
        if (this.materials.size() == 0 && this.oreChance != null && this.smallOreChance != null) {
            throw new RuntimeException("oreChance and smallOreChance is not allowed when no materials are specified");
        }
        this.veinBuilder.addVeinVariant(new WorldGenVeinVariant(this.weight, this.oreChance != null ? this.oreChance.floatValue() : 0.0f, this.smallOreChance != null ? this.smallOreChance.floatValue() : 0.0f, this.markerOreChance != null ? this.markerOreChance.floatValue() : 0.0f, this.surfaceStoneChance != null ? this.surfaceStoneChance.floatValue() : 0.0f, this.materials));
        return this.veinBuilder;
    }

    public final WorldGenVeinVariantBuilder withWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public final WorldGenVeinVariantBuilder withChance(float oreChance, float smallOreChance, float markerOreChance, float surfaceStoneChance) {
        this.oreChance = Float.valueOf(oreChance);
        this.smallOreChance = Float.valueOf(smallOreChance);
        if (AntimatterConfig.WORLD.ORE_VEIN_SMALL_ORE_MARKERS) {
            this.markerOreChance = Float.valueOf(markerOreChance);
        }
        this.surfaceStoneChance = Float.valueOf(surfaceStoneChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withOreChance(float oreChance, float smallOreChance) {
        this.oreChance = Float.valueOf(oreChance);
        this.smallOreChance = Float.valueOf(smallOreChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withNormalChance(float oreChance) {
        this.oreChance = Float.valueOf(oreChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withSmallOreChance(float smallOreChance) {
        this.smallOreChance = Float.valueOf(smallOreChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withMarkerOreChance(float markerOreChance) {
        this.markerOreChance = Float.valueOf(markerOreChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withSurfaceStoneChance(float surfaceStoneChance) {
        this.surfaceStoneChance = Float.valueOf(surfaceStoneChance);
        return this;
    }

    public final WorldGenVeinVariantBuilder withThinChance() {
        return this.withChance(0.05f, 0.1f, 0.01f, 0.01f);
    }

    public final WorldGenVeinVariantBuilder withNormalChance() {
        return this.withChance(0.1f, 0.05f, 0.025f, 0.05f);
    }

    public final WorldGenVeinVariantBuilder withDenseChance() {
        return this.withChance(0.25f, 0.0f, 0.05f, 0.1f);
    }

    public final WorldGenVeinVariantMaterialBuilder withMaterial() {
        return new WorldGenVeinVariantMaterialBuilder(this);
    }

    public final WorldGenVeinVariantBuilder withMaterial(Material material, int weight, int minY, int maxY) {
        return this.withMaterial().withMaterial(material).withWeight(weight).atHeight(minY, maxY).buildMaterial();
    }

    public final WorldGenVeinVariantBuilder withMaterial(Material material, int weight) {
        return this.withMaterial(material, weight, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final WorldGenVeinVariantBuilder withMaterial(Material material) {
        return this.withMaterial(material, 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final WorldGenVeinVariantBuilder withMaterial(Material material, int minY, int maxY) {
        return this.withMaterial(material, 1, minY, maxY);
    }

    final void addVeinMaterial(WorldGenVeinVariantMaterial material) {
        this.materials.add(material);
    }
}

