/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vein.old;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinVariantMaterial;

public class WorldGenVeinVariant {
    public final int weight;
    public final float oreChance;
    public final float smallOreChance;
    public final float markerOreChance;
    public final float surfaceStoneChance;
    public final List<WorldGenVeinVariantMaterial> materials;

    WorldGenVeinVariant(int weight, float oreChance, float smallOreChance, float markerOreChance, float surfaceStoneChance, List<WorldGenVeinVariantMaterial> materials) {
        this.weight = weight;
        this.oreChance = oreChance;
        this.smallOreChance = smallOreChance;
        this.markerOreChance = markerOreChance;
        this.surfaceStoneChance = surfaceStoneChance;
        this.materials = materials;
    }

    static List<WorldGenVeinVariant> getFlat(int weight, float oreChance, float smallOreChance, float markerOreChance, float surfaceStoneChance, List<WorldGenVeinVariantMaterial> materials) {
        return IntStream.range(0, weight).mapToObj(i -> {
            ArrayList<WorldGenVeinVariantMaterial> flatMaterials = new ArrayList<WorldGenVeinVariantMaterial>();
            for (WorldGenVeinVariantMaterial material : materials) {
                flatMaterials.addAll(WorldGenVeinVariantMaterial.getFlat(material.weight, material.material, material.minY, material.maxY));
            }
            return new WorldGenVeinVariant(1, oreChance, smallOreChance, markerOreChance, surfaceStoneChance, flatMaterials);
        }).collect(Collectors.toList());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("weight", (Number)this.weight);
        json.addProperty("oreChance", (Number)Float.valueOf(this.oreChance));
        json.addProperty("smallOreChance", (Number)Float.valueOf(this.smallOreChance));
        json.addProperty("markerOreChance", (Number)Float.valueOf(this.markerOreChance));
        json.addProperty("surfaceStoneChance", (Number)Float.valueOf(this.surfaceStoneChance));
        JsonArray array = new JsonArray();
        this.materials.forEach(m -> array.add((JsonElement)m.toJson()));
        if (!array.isEmpty()) {
            json.add("materials", (JsonElement)array);
        }
        return json;
    }

    public static WorldGenVeinVariant fromJson(JsonObject json) {
        ArrayList<WorldGenVeinVariantMaterial> materials = new ArrayList<WorldGenVeinVariantMaterial>();
        if (json.has("materials")) {
            JsonArray array = json.getAsJsonArray("materials");
            array.forEach(j -> {
                if (j instanceof JsonObject) {
                    JsonObject object = (JsonObject)j;
                    materials.add(WorldGenVeinVariantMaterial.fromJson(object));
                }
            });
        }
        return new WorldGenVeinVariant(json.get("weight").getAsInt(), json.get("oreChance").getAsFloat(), json.get("smallOreChance").getAsFloat(), json.get("markerOreChance").getAsFloat(), json.get("surfaceStoneChance").getAsFloat(), materials);
    }
}

