/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vein.old;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import muramasa.antimatter.worldgen.vein.old.WorldGenVeinVariant;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WorldGenVein
extends WorldGenBase<WorldGenVein> {
    public static final int STONE_VEIN_LAYER = 0;
    public static final int STONE_ORE_VEIN_LAYER = 1;
    public static final int ORE_VEIN_LAYER = 2;
    private static final HashMap<Integer, Integer> MAX_SIZE_PER_LAYER = new HashMap();
    private static final HashMap<Integer, Float> CHANCE_PER_LAYER = new HashMap();
    public final int layer;
    public final int weight;
    public final int minY;
    public final int maxY;
    public final int density;
    public final int minSize;
    public final int maxSize;
    public final float heightScale;
    @Nullable
    public final BlockState fill;
    public final List<WorldGenVeinVariant> variants;

    WorldGenVein(String id, int layer, int weight, int minY, int maxY, int density, int minSize, int maxSize, float heightScale, @Nullable BlockState fill, List<WorldGenVeinVariant> variants, List<ResourceKey<Level>> dimensions) {
        super(id, WorldGenVein.class, dimensions);
        this.layer = layer;
        this.weight = weight;
        this.minY = minY;
        this.maxY = maxY;
        this.density = density;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.heightScale = heightScale;
        this.fill = fill;
        this.variants = variants;
        Integer existingMaxSize = MAX_SIZE_PER_LAYER.get(layer);
        if (existingMaxSize == null || maxSize > existingMaxSize) {
            MAX_SIZE_PER_LAYER.put(layer, maxSize);
        }
    }

    static List<WorldGenVein> getFlat(String id, int layer, int weight, int minY, int maxY, int density, int minSize, int maxSize, float heightScale, @Nullable BlockState fill, List<WorldGenVeinVariant> variants, List<ResourceKey<Level>> dimensions) {
        return IntStream.range(0, weight).mapToObj(i -> {
            ArrayList<WorldGenVeinVariant> flatVariants = new ArrayList<WorldGenVeinVariant>();
            for (WorldGenVeinVariant variant : variants) {
                flatVariants.addAll(WorldGenVeinVariant.getFlat(variant.weight, variant.oreChance, variant.smallOreChance, variant.markerOreChance, variant.surfaceStoneChance, variant.materials));
            }
            return new WorldGenVein(id, layer, 1, minY, maxY, density, minSize, maxSize, heightScale, fill, flatVariants, dimensions);
        }).collect(Collectors.toList());
    }

    static List<WorldGenVein> getFlat(WorldGenVein vein) {
        return WorldGenVein.getFlat(vein.getId(), vein.layer, vein.weight, vein.minY, vein.maxY, vein.density, vein.minSize, vein.maxSize, vein.heightScale, vein.fill, vein.variants, vein.getDims().stream().map(r -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)r)).toList());
    }

    public static Set<Integer> getAllLayers() {
        return MAX_SIZE_PER_LAYER.keySet();
    }

    public static int getMaxLayerSize(int layer) {
        Integer size = MAX_SIZE_PER_LAYER.get(layer);
        if (size != null) {
            return size;
        }
        return 0;
    }

    public static void setLayerChance(int layer, float chance) {
        CHANCE_PER_LAYER.put(layer, Float.valueOf(chance));
    }

    public static double getLayerChance(int layer) {
        Float chance = CHANCE_PER_LAYER.get(layer);
        if (chance != null) {
            return chance.floatValue();
        }
        return 0.1;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("layer", (Number)this.layer);
        json.addProperty("weight", (Number)this.weight);
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        json.addProperty("density", (Number)this.density);
        json.addProperty("minSize", (Number)this.minSize);
        json.addProperty("maxSize", (Number)this.maxSize);
        json.addProperty("heightScale", (Number)Float.valueOf(this.heightScale));
        if (this.fill != null) {
            json.addProperty("fill", AntimatterPlatformUtils.getIdFromBlock(this.fill.m_60734_()).toString());
        }
        JsonArray array = new JsonArray();
        this.variants.forEach(m -> array.add((JsonElement)m.toJson()));
        if (!array.isEmpty()) {
            json.add("variants", (JsonElement)array);
        }
        JsonArray array2 = new JsonArray();
        this.getDims().forEach(r -> array2.add(r.toString()));
        if (!array2.isEmpty()) {
            json.add("dims", (JsonElement)array2);
        }
        return json;
    }

    public static WorldGenVein fromJson(String id, JsonObject json) {
        JsonArray array;
        ArrayList<WorldGenVeinVariant> variants = new ArrayList<WorldGenVeinVariant>();
        ArrayList<ResourceKey<Level>> dims = new ArrayList<ResourceKey<Level>>();
        if (json.has("variants")) {
            array = json.getAsJsonArray("variants");
            array.forEach(j -> {
                if (j instanceof JsonObject) {
                    JsonObject object = (JsonObject)j;
                    variants.add(WorldGenVeinVariant.fromJson(object));
                }
            });
        }
        if (json.has("dims")) {
            array = json.getAsJsonArray("dims");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    dims.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(object.getAsString())));
                }
            });
        }
        BlockState fill = json.has("fill") ? AntimatterPlatformUtils.getBlockFromId(new ResourceLocation(json.get("fill").getAsString())).m_49966_() : null;
        return new WorldGenVein(id, json.get("layer").getAsInt(), json.get("weight").getAsInt(), json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE, json.get("density").getAsInt(), json.get("minSize").getAsInt(), json.get("maxSize").getAsInt(), json.get("heightScale").getAsFloat(), fill, variants, dims);
    }
}

