/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vein;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.Ref;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.util.XSTR;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.VeinLayerResult;
import muramasa.antimatter.worldgen.WorldGenHelper;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class WorldGenVeinLayer
extends WorldGenBase<WorldGenVeinLayer> {
    static int TOTAL_WEIGHT;
    public static Long2ObjectOpenHashMap<WorldGenVeinLayer> VALID_VEINS;
    private static final WorldGenVeinLayer NO_ORES_IN_VEIN;
    private Material[] materials;
    private String primary;
    private String secondary;
    private String between;
    private String sporadic;
    private final int minY;
    private final int maxY;
    private final int weight;
    private final int density;
    private final int size;

    WorldGenVeinLayer(String id, int minY, int maxY, int weight, int density, int size, Material primary, Material secondary, Material between, Material sporadic, List<ResourceKey<Level>> dimensions) {
        super(id, WorldGenVeinLayer.class, dimensions);
        this.minY = minY;
        this.maxY = maxY;
        this.weight = weight;
        this.density = density;
        this.size = size;
        this.materials = new Material[]{primary, secondary, between, sporadic};
        if (primary != null && primary != Material.NULL) {
            this.primary = primary.getId();
            this.secondary = secondary.getId();
            this.between = between.getId();
            this.sporadic = sporadic.getId();
        }
        TOTAL_WEIGHT += weight;
    }

    public static void resetTotalWeight() {
        TOTAL_WEIGHT = 0;
    }

    public WorldGenVeinLayer onDataOverride(JsonObject json) {
        super.onDataOverride(json);
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("weight", (Number)this.weight);
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        json.addProperty("density", (Number)this.density);
        json.addProperty("size", (Number)this.size);
        json.addProperty("primary", this.primary);
        json.addProperty("secondary", this.secondary);
        json.addProperty("between", this.between);
        json.addProperty("sporadic", this.sporadic);
        JsonArray array2 = new JsonArray();
        this.getDims().forEach(r -> array2.add(r.toString()));
        if (!array2.isEmpty()) {
            json.add("dims", (JsonElement)array2);
        }
        return json;
    }

    public static WorldGenVeinLayer fromJson(String id, JsonObject json) {
        ArrayList<ResourceKey<Level>> dims = new ArrayList<ResourceKey<Level>>();
        if (json.has("dims")) {
            JsonArray array = json.getAsJsonArray("dims");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    dims.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(object.getAsString())));
                }
            });
        }
        return new WorldGenVeinLayer(id, json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE, json.get("weight").getAsInt(), json.get("density").getAsInt(), json.get("size").getAsInt(), Material.get(json.get("primary").getAsString()), Material.get(json.get("secondary").getAsString()), Material.get(json.get("between").getAsString()), Material.get(json.get("sporadic").getAsString()), dims);
    }

    public Material getMaterial(int i) {
        return this.materials[i];
    }

    public int getWeight() {
        return this.weight;
    }

    public static int getTotalWeight() {
        return TOTAL_WEIGHT;
    }

    public static void generate(WorldGenLevel world, int chunkX, int chunkZ, int oreSeedX, int oreSeedZ) {
        List<WorldGenVeinLayer> veins = AntimatterWorldGenerator.all(WorldGenVeinLayer.class, (ResourceKey<Level>)world.m_6018_().m_46472_());
        if (veins == null || veins.size() == 0) {
            return;
        }
        long oreVeinSeed = WorldGenVeinLayer.getOreVeinSeed(world, oreSeedX, oreSeedZ);
        XSTR oreVeinRNG = new XSTR(oreVeinSeed);
        int oreVeinPercentageRoll = oreVeinRNG.nextInt(100);
        if (Ref.debugOreVein) {
            Antimatter.LOGGER.info("Finding oreveins for oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " worldSeed=" + world.m_7328_());
        }
        if (!VALID_VEINS.containsKey(oreVeinSeed)) {
            int veinCount = veins.size();
            if (oreVeinPercentageRoll < AntimatterConfig.WORLD.ORE_VEIN_CHANCE && TOTAL_WEIGHT > 0 && veinCount > 0) {
                int i;
                int placementAttempts = 0;
                boolean oreVeinFound = false;
                block10: for (i = 0; i < AntimatterConfig.WORLD.ORE_VEIN_FIND_ATTEMPTS && !oreVeinFound && placementAttempts < AntimatterConfig.WORLD.ORE_VEIN_PLACE_ATTEMPTS; ++i) {
                    int tRandomWeight = oreVeinRNG.nextInt(TOTAL_WEIGHT);
                    for (WorldGenVeinLayer vein : veins) {
                        if ((tRandomWeight -= vein.weight) > 0) continue;
                        VeinLayerResult placementResult = vein.generateChunkified(world, new XSTR(oreVeinSeed ^ (long)vein.primary.hashCode()), chunkX * 16, chunkZ * 16, oreSeedX * 16, oreSeedZ * 16);
                        switch (placementResult) {
                            case ORE_PLACED: {
                                if (Ref.debugOreVein) {
                                    Antimatter.LOGGER.info("Added near oreVeinSeed=" + oreVeinSeed + " " + vein.getId() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                VALID_VEINS.put(oreVeinSeed, (Object)vein);
                                oreVeinFound = true;
                                break;
                            }
                            case NO_ORE_IN_BOTTOM_LAYER: {
                                ++placementAttempts;
                                break;
                            }
                            case NO_OVERLAP: {
                                if (Ref.debugOreVein) {
                                    Antimatter.LOGGER.info("Added far oreVeinSeed=" + oreVeinSeed + " " + vein.getId() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                VALID_VEINS.put(oreVeinSeed, (Object)vein);
                                oreVeinFound = true;
                                break;
                            }
                            case NO_OVERLAP_AIR_BLOCK: {
                                if (Ref.debugOreVein) {
                                    Antimatter.LOGGER.info("No overlap and air block in test spot=" + oreVeinSeed + " " + vein.getId() + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                                }
                                ++placementAttempts;
                            }
                        }
                        continue block10;
                    }
                }
                if (!oreVeinFound && chunkX == oreSeedX && chunkZ == oreSeedZ) {
                    if (Ref.debugOreVein) {
                        Antimatter.LOGGER.info("Empty oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " tries at oremix=" + i + " placementAttempts=" + placementAttempts + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                    }
                    VALID_VEINS.put(oreVeinSeed, (Object)NO_ORES_IN_VEIN);
                }
            } else if (oreVeinPercentageRoll >= AntimatterConfig.WORLD.ORE_VEIN_CHANCE) {
                if (Ref.debugOreVein) {
                    Antimatter.LOGGER.info("Skipped oreVeinSeed=" + oreVeinSeed + " chunkX=" + chunkX + " chunkZ=" + chunkZ + " oreSeedX=" + oreSeedX + " oreSeedZ=" + oreSeedZ + " RNG=" + oreVeinPercentageRoll + " %=" + AntimatterConfig.WORLD.ORE_VEIN_CHANCE + " dimension=" + world.m_6018_().m_46472_().m_135782_());
                }
                VALID_VEINS.put(oreVeinSeed, (Object)NO_ORES_IN_VEIN);
            }
        } else {
            WorldGenVeinLayer vein;
            if (Ref.debugOreVein) {
                Antimatter.LOGGER.info("Valid oreVeinSeed=" + oreVeinSeed + " VALID_VEINS.size()=" + VALID_VEINS.size() + " ");
            }
            if ((vein = (WorldGenVeinLayer)VALID_VEINS.get(oreVeinSeed)) == null) {
                throw new IllegalStateException("Valid veins returned null in WorldGenVeinlayer. This is an error");
            }
            if (vein.primary != null) {
                oreVeinRNG.setSeed(oreVeinSeed ^ (long)vein.primary.hashCode());
            }
            VeinLayerResult placementResult = vein.generateChunkified(world, oreVeinRNG, chunkX * 16, chunkZ * 16, oreSeedX * 16, oreSeedZ * 16);
            switch (placementResult) {
                case NO_ORE_IN_BOTTOM_LAYER: {
                    if (!Ref.debugOreVein) break;
                    Antimatter.LOGGER.info(" No ore in bottom layer");
                    break;
                }
                case NO_OVERLAP: {
                    if (!Ref.debugOreVein) break;
                    Antimatter.LOGGER.info(" No overlap");
                }
            }
        }
    }

    public static long getOreVeinSeed(WorldGenLevel world, long oreSeedX, long oreSeedZ) {
        return world.m_7328_() << 16 ^ (((long)world.m_6018_().m_46472_().m_135782_().hashCode() & 0xFFL) << 56 | (oreSeedX & 0xFFFFFFFL) << 28 | oreSeedZ & 0xFFFFFFFL);
    }

    VeinLayerResult generateChunkified(WorldGenLevel world, XSTR rand, int posX, int posZ, int seedX, int seedZ) {
        int sZ;
        int tMinY = this.minY + rand.nextInt(this.maxY - this.minY - 5);
        int wXVein = seedX - rand.nextInt(this.size);
        int eXVein = seedX + 16 + rand.nextInt(this.size);
        int wX = Math.max(wXVein, posX);
        int eX = Math.min(eXVein, posX + 16);
        BlockPos centerPos = new BlockPos(posX + 7, tMinY, posZ + 9);
        BlockState centerState = world.m_8055_(centerPos);
        if (wX >= eX) {
            if (WorldGenHelper.ORE_PREDICATE.test(centerState)) {
                return VeinLayerResult.NO_OVERLAP;
            }
            return VeinLayerResult.NO_OVERLAP_AIR_BLOCK;
        }
        int nZVein = seedZ - rand.nextInt(this.size);
        int sZVein = seedZ + 16 + rand.nextInt(this.size);
        int nZ = Math.max(nZVein, posZ);
        if (nZ >= (sZ = Math.min(sZVein, posZ + 16))) {
            if (WorldGenHelper.ORE_PREDICATE.test(centerState)) {
                return VeinLayerResult.NO_OVERLAP;
            }
            return VeinLayerResult.NO_OVERLAP_AIR_BLOCK;
        }
        if (Ref.debugOreVein) {
            Antimatter.LOGGER.info("Trying Orevein:" + this.getId() + " Dimension=" + world.m_6018_().m_46472_() + " posX=" + posX / 16 + " posZ=" + posZ / 16 + " oreseedX=" + seedX / 16 + " oreseedZ=" + seedZ / 16 + " cY=" + tMinY);
        }
        if (!this.generateSquare((LevelAccessor)world, rand, posX, posZ, seedX, seedZ, tMinY, wXVein, eXVein, nZVein, sZVein, wX, eX, nZ, sZ)) {
            return VeinLayerResult.NO_ORE_IN_BOTTOM_LAYER;
        }
        if (AntimatterConfig.WORLD.ORE_VEIN_SMALL_ORE_MARKERS) {
            int nSmallOres = (eX - wX) * (sZ - nZ) * this.density / 20 * AntimatterConfig.WORLD.ORE_VEIN_SMALL_ORE_MARKERS_MULTI;
            this.generateMarkers((LevelAccessor)world, rand, posX, posZ, nSmallOres, 7);
        }
        return VeinLayerResult.ORE_PLACED;
    }

    void generateMarkers(LevelAccessor world, XSTR rand, int posX, int posZ, int nSmallOres, int nRocks) {
        int tZ;
        int tX;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int nSmallOresCount = 0; nSmallOresCount < nSmallOres; ++nSmallOresCount) {
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            int tY = rand.nextInt(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[0], AntimatterMaterialTypes.ORE_SMALL);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            tY = rand.nextInt(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[1], AntimatterMaterialTypes.ORE_SMALL);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            tY = rand.nextInt(224) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[2], AntimatterMaterialTypes.ORE_SMALL);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            tY = rand.nextInt(254) - 54;
            pos.m_122178_(tX, tY, tZ);
            WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE_SMALL);
        }
        for (int rockCount = 0; rockCount < nRocks; ++rockCount) {
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), this.materials[0], AntimatterConfig.WORLD.ORE_VEIN_ROCK_CHANCE);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), this.materials[0], AntimatterConfig.WORLD.ORE_VEIN_ROCK_CHANCE * 3 / 2);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), this.materials[0], AntimatterConfig.WORLD.ORE_VEIN_ROCK_CHANCE * 2);
            tX = rand.nextInt(16) + posX;
            tZ = rand.nextInt(16) + posZ;
            WorldGenHelper.addRock(world, (BlockPos)pos.m_122178_(tX, 0, tZ), this.materials[0], AntimatterConfig.WORLD.ORE_VEIN_ROCK_CHANCE * 5 / 2);
        }
    }

    boolean generateSquare(LevelAccessor world, XSTR rand, int posX, int posZ, int seedX, int seedZ, int tMinY, int wXVein, int eXVein, int nZVein, int sZVein, int wX, int eX, int nZ, int sZ) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int[] placeCount = new int[4];
        int localDensity = Math.max(1, this.density / (int)Math.sqrt(2.0 + Math.pow(posX / 16 - seedX / 16, 2.0) + Math.pow(posZ / 16 - seedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[1], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (placeCount[1] + placeCount[3] == 0) {
            if (Ref.debugOreVein) {
                Antimatter.LOGGER.info(" No ore in bottom layer");
            }
            return false;
        }
        for (level = tMinY; level < tMinY + 2; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                    if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                        pos.m_122178_(tX, level, tZ);
                        if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[1], AntimatterMaterialTypes.ORE)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(2) == 0 && (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[2], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[1], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(2) == 0 && (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[2], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(2) == 0 && (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[2], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[0], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(2) == 0 && (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0)) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[2], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[0], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[0], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(Mth.m_14040_((int)(wXVein - tX)), Mth.m_14040_((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(Mth.m_14040_((int)(sZVein - tZ)), Mth.m_14040_((int)(nZVein - tZ))) / localDensity);
                if (rand.nextInt(placeZ) == 0 || rand.nextInt(placeX) == 0) {
                    pos.m_122178_(tX, level, tZ);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[0], AntimatterMaterialTypes.ORE)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (rand.nextInt(7) != 0 || rand.nextInt(placeZ) != 0 && rand.nextInt(placeX) != 0) continue;
                pos.m_122178_(tX, level, tZ);
                if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (Ref.debugOreVein) {
            Antimatter.LOGGER.info(" wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + this.density + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return true;
    }

    boolean generateByFunction(LevelAccessor world, XSTR rand, int tMinY, int wXVein, int eXVein, int nZVein, int sZVein, int wX, int eX, int nZ, int sZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int[] placeCount = new int[4];
        int centerX = (wXVein + eXVein) / 2;
        int centerY = tMinY + 4;
        int centerZ = (nZVein + sZVein) / 2;
        double a = 4.0 / (double)((wXVein - eXVein) * (wXVein - eXVein));
        double b = 0.04;
        double c = 4.0 / (double)((nZVein - sZVein) * (nZVein - sZVein));
        for (int y = tMinY - 1; y < tMinY + 8; ++y) {
            for (int x = wX; x < eX; ++x) {
                for (int z = nZ; z < sZ; ++z) {
                    int oreIndex;
                    double p = 1.0 - a * (double)(centerX - x) * (double)(centerX - x) - 0.04 * (double)(centerY - y) * (double)(centerY - y) - c * (double)(centerZ - z) * (double)(centerZ - z);
                    if (p <= 0.0 || (double)rand.nextInt(100) > 100.0 * p || rand.nextInt(12) > this.density) continue;
                    pos.m_122178_(x, y, z);
                    if (rand.nextInt(100) < 10) {
                        if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[3], AntimatterMaterialTypes.ORE)) continue;
                        placeCount[3] = placeCount[3] + 1;
                        continue;
                    }
                    int n = p > 0.5 ? 0 : (oreIndex = p > 0.2 ? 1 : 2);
                    if (!WorldGenHelper.setOre(world, (BlockPos)pos, world.m_8055_((BlockPos)pos), this.materials[oreIndex], AntimatterMaterialTypes.ORE)) continue;
                    int n2 = oreIndex;
                    placeCount[n2] = placeCount[n2] + 1;
                }
            }
            if (y != tMinY + 1 || placeCount[0] + placeCount[1] + placeCount[2] + placeCount[3] != 0) continue;
            if (Ref.debugOreVein) {
                Antimatter.LOGGER.info(" No ore in bottom layer");
            }
            return false;
        }
        if (Ref.debugOreVein) {
            Antimatter.LOGGER.info(" wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " Den=" + this.density + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return true;
    }

    static {
        VALID_VEINS = new Long2ObjectOpenHashMap();
        NO_ORES_IN_VEIN = new WorldGenVeinLayer("no_ores_in_vein", 0, 255, 0, 255, 16, Material.NULL, Material.NULL, Material.NULL, Material.NULL, List.of()){

            @Override
            VeinLayerResult generateChunkified(WorldGenLevel world, XSTR rand, int posX, int posZ, int seedX, int seedZ) {
                return VeinLayerResult.NO_ORES_VEIN;
            }
        };
    }
}

