/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vanillaore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.vanillaore.WorldGenVanillaOre;
import net.minecraft.resources.ResourceLocation;

public class WorldGenVanillaOreBuilder {
    @Nullable
    private Material material;
    @Nullable
    private Material secondary;
    @Nullable
    private MaterialTypeBlock<?> materialType;
    @Nullable
    private MaterialTypeBlock<?> secondaryType;
    @Nullable
    private Integer weight;
    @Nullable
    private Integer maxY;
    @Nullable
    private Integer minY;
    @Nullable
    private Integer size;
    @Nullable
    private Integer plateau;
    @Nullable
    private Float secondaryChance;
    @Nullable
    private Float discardOnExposureChance;
    @Nullable
    String id;
    List<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
    List<String> biomes = new ArrayList<String>();
    boolean biomeBlacklist = true;
    boolean rare = false;
    boolean triangle = false;
    boolean spawnOnOceanFloor = false;

    public final WorldGenVanillaOre buildMaterial() {
        if (this.weight == null) {
            throw new RuntimeException("weight is required");
        }
        if (this.size == null) {
            throw new RuntimeException("size is required");
        }
        if (this.material == null) {
            throw new RuntimeException("material is required");
        }
        if (this.dimensions.isEmpty()) {
            this.dimensions.add(new ResourceLocation("overworld"));
        }
        MaterialTypeBlock<MaterialTypeBlock.IOreGetter> materialTypeBlock = this.materialType == null ? AntimatterMaterialTypes.ORE : this.materialType;
        WorldGenVanillaOre vanillaOre = new WorldGenVanillaOre(this.id != null ? this.id : this.material.getId(), this.material, this.secondary == null ? Material.NULL : this.secondary, materialTypeBlock, this.secondaryType == null ? materialTypeBlock : this.secondaryType, this.secondaryChance == null ? 0.0f : this.secondaryChance.floatValue(), this.discardOnExposureChance == null ? 0.0f : this.discardOnExposureChance.floatValue(), this.minY != null ? this.minY : Integer.MIN_VALUE, this.maxY != null ? this.maxY : Integer.MAX_VALUE, this.weight, this.size, this.rare, this.triangle, this.plateau == null ? 0 : this.plateau, this.spawnOnOceanFloor, this.dimensions, this.biomes, this.biomeBlacklist);
        AntimatterWorldGenerator.writeJson(vanillaOre.toJson(), vanillaOre.getId(), "vanilla_ore");
        return AntimatterWorldGenerator.readJson(WorldGenVanillaOre.class, vanillaOre, WorldGenVanillaOre::fromJson, "vanilla_ore");
    }

    public final WorldGenVanillaOreBuilder withMaterial(Material material) {
        this.material = material;
        return this;
    }

    public final WorldGenVanillaOreBuilder withSecondaryMaterial(Material secondary, float secondaryChance) {
        this.secondary = secondary;
        this.secondaryChance = Float.valueOf(secondaryChance);
        return this;
    }

    public final WorldGenVanillaOreBuilder withSecondaryType(MaterialTypeBlock<?> materialType) {
        this.secondaryType = materialType;
        return this;
    }

    public final WorldGenVanillaOreBuilder withMaterialType(MaterialTypeBlock<?> materialType) {
        this.materialType = materialType;
        return this;
    }

    public final WorldGenVanillaOreBuilder withWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public final WorldGenVanillaOreBuilder withSize(int size) {
        this.size = size;
        return this;
    }

    public final WorldGenVanillaOreBuilder withDiscardOnExposureChance(float discardOnExposureChance) {
        this.discardOnExposureChance = Float.valueOf(discardOnExposureChance);
        return this;
    }

    public final WorldGenVanillaOreBuilder atHeight(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public final WorldGenVanillaOreBuilder withCustomId(String id) {
        this.id = id;
        return this;
    }

    public final WorldGenVanillaOreBuilder withBiomes(String ... biomes) {
        Collections.addAll(this.biomes, biomes);
        return this;
    }

    public final WorldGenVanillaOreBuilder withDimensions(ResourceLocation ... dimensions) {
        Collections.addAll(this.dimensions, dimensions);
        return this;
    }

    public final WorldGenVanillaOreBuilder setBiomeBlacklist(boolean blacklist) {
        this.biomeBlacklist = blacklist;
        return this;
    }

    public final WorldGenVanillaOreBuilder setRare(boolean rare) {
        this.rare = rare;
        return this;
    }

    public final WorldGenVanillaOreBuilder setHasTriangleHeight(boolean triangle) {
        this.triangle = triangle;
        return this;
    }

    public final WorldGenVanillaOreBuilder setHasTriangleHeight(boolean triangle, int plateau) {
        this.triangle = triangle;
        this.plateau = plateau;
        return this;
    }

    public final WorldGenVanillaOreBuilder setSpawnOnOceanFloor(boolean spawnOnOceanFloor) {
        this.spawnOnOceanFloor = spawnOnOceanFloor;
        return this;
    }
}

