/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.vanillaore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class WorldGenVanillaOre
extends WorldGenBase<WorldGenVanillaOre> {
    public final Material primary;
    public final Material secondary;
    public final MaterialType<?> materialType;
    public final MaterialType<?> secondaryType;
    public final int minY;
    public final int maxY;
    public final int weight;
    public final int size;
    public final int plateau;
    public final float secondaryChance;
    public final float discardOnExposureChance;
    public final List<ResourceLocation> dimensions;
    public final List<String> biomes;
    public final boolean biomeBlacklist;
    public final boolean rare;
    public final boolean triangle;
    public final boolean spawnOnOceanFloor;

    WorldGenVanillaOre(String id, Material primary, Material secondary, MaterialType<?> type, MaterialType<?> secondaryType, float secondaryChance, float discardOnExposureChance, int minY, int maxY, int weight, int size, boolean rare, boolean triangle, int plateau, boolean spawnOnOceanFlor, List<ResourceLocation> dimensions, List<String> biomes, boolean biomeBlacklist) {
        super(id, WorldGenVanillaOre.class, dimensions.stream().map(r -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)r)).toList());
        this.primary = primary;
        this.secondary = secondary;
        this.materialType = type;
        this.secondaryType = secondaryType;
        this.secondaryChance = secondaryChance;
        this.discardOnExposureChance = discardOnExposureChance;
        this.minY = minY;
        this.maxY = maxY;
        this.weight = weight;
        this.size = size;
        this.rare = rare;
        this.triangle = triangle;
        this.plateau = plateau;
        this.spawnOnOceanFloor = spawnOnOceanFlor;
        this.dimensions = dimensions;
        this.biomes = biomes;
        this.biomeBlacklist = biomeBlacklist;
    }

    @Override
    public Predicate<Holder<Biome>> getValidBiomes() {
        return b -> {
            if (this.biomes.isEmpty()) {
                return this.biomeBlacklist;
            }
            Predicate<String> predicate = s -> {
                if (s.contains("#")) {
                    return b.m_203656_(TagUtils.getBiomeTag(new ResourceLocation(s.replace("#", ""))));
                }
                return b.m_203565_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s)));
            };
            return this.biomeBlacklist ? this.biomes.stream().anyMatch(predicate) : this.biomes.stream().noneMatch(predicate);
        };
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("primary", this.primary.getId());
        if (this.materialType != AntimatterMaterialTypes.ORE) {
            json.addProperty("materialType", this.materialType.getId());
        }
        if (this.secondary != Material.NULL) {
            json.addProperty("secondary", this.secondary.getId());
            json.addProperty("secondaryChance", (Number)Float.valueOf(this.secondaryChance));
            if (this.secondaryType != this.materialType) {
                json.addProperty("secondaryType", this.secondaryType.getId());
            }
        }
        json.addProperty("discardOnExposureChance", (Number)Float.valueOf(this.discardOnExposureChance));
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        json.addProperty("weight", (Number)this.weight);
        json.addProperty("size", (Number)this.size);
        if (this.rare) {
            json.addProperty("rare", Boolean.valueOf(true));
        }
        if (this.triangle) {
            json.addProperty("triangle", Boolean.valueOf(true));
        }
        if (this.plateau > 0) {
            json.addProperty("plateau", (Number)this.plateau);
        }
        if (this.spawnOnOceanFloor) {
            json.addProperty("spawnOnOceanFloor", Boolean.valueOf(true));
        }
        JsonArray array = new JsonArray();
        this.getDims().forEach(r -> array.add(r.toString()));
        if (!array.isEmpty()) {
            json.add("dims", (JsonElement)array);
        }
        JsonArray array2 = new JsonArray();
        this.biomes.forEach(arg_0 -> ((JsonArray)array2).add(arg_0));
        if (!array2.isEmpty()) {
            json.add("biomes", (JsonElement)array2);
        }
        json.addProperty("biomeBlacklist", Boolean.valueOf(this.biomeBlacklist));
        return json;
    }

    public static WorldGenVanillaOre fromJson(String id, JsonObject json) {
        JsonArray array;
        ArrayList<String> biomes = new ArrayList<String>();
        ArrayList<ResourceLocation> dims = new ArrayList<ResourceLocation>();
        if (json.has("biomes")) {
            array = json.getAsJsonArray("biomes");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    biomes.add(object.getAsString());
                }
            });
        }
        if (json.has("dims")) {
            array = json.getAsJsonArray("dims");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    dims.add(new ResourceLocation(object.getAsString()));
                }
            });
        }
        MaterialTypeBlock<MaterialTypeBlock.IOreGetter> materialType = json.has("materialType") ? AntimatterAPI.get(MaterialType.class, json.get("materialType").getAsString()) : AntimatterMaterialTypes.ORE;
        return new WorldGenVanillaOre(id, Material.get(json.get("primary").getAsString()), json.has("secondary") ? Material.get(json.get("secondary").getAsString()) : Material.NULL, materialType, json.has("secondaryType") ? AntimatterAPI.get(MaterialType.class, json.get("secondaryType").getAsString()) : materialType, json.has("secondaryChance") ? json.get("secondaryChance").getAsFloat() : 0.0f, json.get("discardOnExposureChance").getAsFloat(), json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE, json.get("weight").getAsInt(), json.get("size").getAsInt(), json.has("rare") && json.get("rare").getAsBoolean(), json.has("triangle") && json.get("triangle").getAsBoolean(), json.has("plateau") ? json.get("plateau").getAsInt() : 0, json.has("spawnOnOceanFloor") && json.get("spawnOnOceanFloor").getAsBoolean(), dims, biomes, json.get("biomeBlacklist").getAsBoolean());
    }
}

