/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.smallore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.smallore.WorldGenSmallOre;
import muramasa.antimatter.worldgen.vein.old.WorldGenVein;
import net.minecraft.resources.ResourceLocation;

public class WorldGenSmallOreBuilder {
    @Nullable
    private Material material;
    @Nullable
    private Integer amountPerChunk;
    @Nullable
    private Integer maxY;
    @Nullable
    private Integer minY;
    @Nullable
    String id;
    List<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
    List<String> biomes = new ArrayList<String>();
    boolean dimensionBlacklist = false;
    boolean biomeBlacklist = true;

    public final WorldGenSmallOre buildMaterial() {
        if (this.amountPerChunk == null) {
            throw new RuntimeException("weight is required");
        }
        if (this.material == null) {
            throw new RuntimeException("material is required");
        }
        if (this.dimensions.isEmpty()) {
            this.dimensions.add(new ResourceLocation("overworld"));
        }
        WorldGenSmallOre smallOre = new WorldGenSmallOre(this.id != null ? this.id : this.material.getId(), this.material, this.minY != null ? this.minY : Integer.MIN_VALUE, this.maxY != null ? this.maxY : Integer.MAX_VALUE, this.amountPerChunk, this.dimensions, this.biomes, this.biomeBlacklist);
        AntimatterWorldGenerator.writeJson(smallOre.toJson(), smallOre.getId(), "small_ore");
        return AntimatterWorldGenerator.readJson(WorldGenSmallOre.class, smallOre, WorldGenSmallOre::fromJson, "small_ore");
    }

    private WorldGenVein readJson(WorldGenVein original) {
        File dir = new File(AntimatterPlatformUtils.getConfigDir().toFile(), "antimatter/small_ore/overrides");
        File target = new File(dir, this.id + ".json");
        if (target.exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(target.toPath());
                JsonObject parsed = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                WorldGenVein read = WorldGenVein.fromJson(this.id, parsed);
                ((Reader)reader).close();
                return read;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return original;
    }

    public final WorldGenSmallOreBuilder withMaterial(Material material) {
        this.material = material;
        return this;
    }

    public final WorldGenSmallOreBuilder withAmountPerChunk(int amountPerChunk) {
        this.amountPerChunk = amountPerChunk;
        return this;
    }

    public final WorldGenSmallOreBuilder atHeight(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public final WorldGenSmallOreBuilder withCustomId(String id) {
        this.id = id;
        return this;
    }

    public final WorldGenSmallOreBuilder withBiomes(String ... biomes) {
        Collections.addAll(this.biomes, biomes);
        return this;
    }

    public final WorldGenSmallOreBuilder withDimensions(ResourceLocation ... dimensions) {
        Collections.addAll(this.dimensions, dimensions);
        return this;
    }

    public final WorldGenSmallOreBuilder setBiomeBlacklist(boolean blacklist) {
        this.biomeBlacklist = blacklist;
        return this;
    }
}

