/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.smallore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class WorldGenSmallOre
extends WorldGenBase<WorldGenSmallOre> {
    public final Material material;
    public final int minY;
    public final int maxY;
    public final int amountPerChunk;
    public final List<ResourceLocation> dimensions;
    public final List<String> biomes;
    public final boolean biomeBlacklist;

    WorldGenSmallOre(String id, Material material, int minY, int maxY, int amountPerChunk, List<ResourceLocation> dimensions, List<String> biomes, boolean biomeBlacklist) {
        super(id, WorldGenSmallOre.class, dimensions.stream().map(r -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)r)).toList());
        this.material = material;
        this.minY = minY;
        this.maxY = maxY;
        this.amountPerChunk = amountPerChunk;
        this.dimensions = dimensions;
        this.biomes = biomes;
        this.biomeBlacklist = biomeBlacklist;
    }

    @Override
    public Predicate<Holder<Biome>> getValidBiomes() {
        return b -> {
            if (this.biomes.isEmpty()) {
                return this.biomeBlacklist;
            }
            Predicate<String> predicate = s -> {
                if (s.contains("#")) {
                    return b.m_203656_(TagUtils.getBiomeTag(new ResourceLocation(s.replace("#", ""))));
                }
                return b.m_203565_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s)));
            };
            return this.biomeBlacklist ? this.biomes.stream().anyMatch(predicate) : this.biomes.stream().noneMatch(predicate);
        };
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("material", this.material.getId());
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        json.addProperty("amountPerChunk", (Number)this.amountPerChunk);
        JsonArray array = new JsonArray();
        this.getDims().forEach(r -> array.add(r.toString()));
        if (!array.isEmpty()) {
            json.add("dims", (JsonElement)array);
        }
        JsonArray array2 = new JsonArray();
        this.biomes.forEach(arg_0 -> ((JsonArray)array2).add(arg_0));
        if (!array2.isEmpty()) {
            json.add("biomes", (JsonElement)array2);
        }
        json.addProperty("biomeBlacklist", Boolean.valueOf(this.biomeBlacklist));
        return json;
    }

    public static WorldGenSmallOre fromJson(String id, JsonObject json) {
        JsonArray array;
        ArrayList<String> biomes = new ArrayList<String>();
        ArrayList<ResourceLocation> dims = new ArrayList<ResourceLocation>();
        if (json.has("biomes")) {
            array = json.getAsJsonArray("biomes");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    biomes.add(object.getAsString());
                }
            });
        }
        if (json.has("dims")) {
            array = json.getAsJsonArray("dims");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    dims.add(new ResourceLocation(object.getAsString()));
                }
            });
        }
        return new WorldGenSmallOre(id, Material.get(json.get("material").getAsString()), json.get("amountPerChunk").getAsInt(), json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE, dims, biomes, json.get("biomeBlacklist").getAsBoolean());
    }
}

