/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.object;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import muramasa.antimatter.block.BlockStone;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.worldgen.StoneLayerOre;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WorldGenStoneLayer
extends WorldGenBase<WorldGenStoneLayer> {
    private static Int2ObjectOpenHashMap<List<StoneLayerOre>> COLLISION_MAP = new Int2ObjectOpenHashMap();
    private StoneType stoneType;
    private BlockState stoneState;
    private StoneLayerOre[] ores = new StoneLayerOre[0];
    private int minY;
    private int maxY;
    private int weight;

    protected WorldGenStoneLayer(String id, @Nullable StoneType stoneType, BlockState state, int weight, int minY, int maxY, List<ResourceKey<Level>> dims) {
        super(id, WorldGenStoneLayer.class, dims);
        if (state == null || state.m_60795_()) {
            throw new IllegalStateException("WorldGenStoneLayer has been passed a null stone block state!");
        }
        this.stoneState = state;
        this.stoneType = stoneType;
        this.minY = minY;
        this.maxY = maxY;
        this.weight = weight;
    }

    protected WorldGenStoneLayer addOres(StoneLayerOre ... ores) {
        if (this.stoneState.m_60734_() instanceof BlockStone) {
            Arrays.stream(ores).forEach(o -> o.setStatesByStoneType(((BlockStone)this.stoneState.m_60734_()).getType()));
        }
        this.ores = ores;
        return this;
    }

    @Nullable
    public StoneType getStoneType() {
        return this.stoneType;
    }

    public BlockState getStoneState() {
        return this.stoneState;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public StoneLayerOre[] getOres() {
        return this.ores;
    }

    public static void setCollisionMap(Int2ObjectOpenHashMap<List<StoneLayerOre>> collisionMap) {
        COLLISION_MAP = collisionMap;
    }

    public static List<StoneLayerOre> getCollision(StoneType middle, BlockState top, BlockState bottom) {
        if (middle == null) {
            return Collections.emptyList();
        }
        List list = (List)COLLISION_MAP.get(Objects.hash(top, bottom));
        if (list == null) {
            return Collections.emptyList();
        }
        for (StoneLayerOre ore : list) {
            ore.setStatesByStoneType(middle);
        }
        return list;
    }

    static List<WorldGenStoneLayer> getFlat(String id, int weight, int minY, int maxY, @Nullable StoneType stoneType, @Nullable BlockState stoneState, List<ResourceKey<Level>> dimensions) {
        return IntStream.range(0, weight).mapToObj(i -> new WorldGenStoneLayer(id, stoneType, stoneState, 1, minY, maxY, dimensions)).collect(Collectors.toList());
    }

    static List<WorldGenStoneLayer> getFlat(WorldGenStoneLayer vein) {
        return WorldGenStoneLayer.getFlat(vein.getId(), vein.weight, vein.minY, vein.maxY, vein.stoneType, vein.stoneState, vein.getDims().stream().map(r -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)r)).toList());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("weight", (Number)this.weight);
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        if (this.stoneType != null) {
            json.addProperty("stoneType", this.stoneType.getId());
        }
        json.addProperty("stoneState", AntimatterPlatformUtils.getIdFromBlock(this.stoneState.m_60734_()).toString());
        JsonArray array = new JsonArray();
        if (this.ores != null) {
            for (StoneLayerOre ore : this.ores) {
                array.add((JsonElement)ore.toJson());
            }
        }
        if (!array.isEmpty()) {
            json.add("ores", (JsonElement)array);
        }
        JsonArray array2 = new JsonArray();
        this.getDims().forEach(r -> array2.add(r.toString()));
        if (!array2.isEmpty()) {
            json.add("dims", (JsonElement)array2);
        }
        return json;
    }

    public static WorldGenStoneLayer fromJson(String id, JsonObject json) {
        JsonArray array;
        ArrayList ores = new ArrayList();
        ArrayList<ResourceKey<Level>> dims = new ArrayList<ResourceKey<Level>>();
        if (json.has("ores")) {
            array = json.getAsJsonArray("ores");
            array.forEach(j -> {
                if (j instanceof JsonObject) {
                    JsonObject object = (JsonObject)j;
                    ores.add(StoneLayerOre.fromJson(object));
                }
            });
        }
        if (json.has("dims")) {
            array = json.getAsJsonArray("dims");
            array.forEach(j -> {
                if (j instanceof JsonPrimitive) {
                    JsonPrimitive object = (JsonPrimitive)j;
                    dims.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(object.getAsString())));
                }
            });
        }
        BlockState fill = json.has("fill") ? AntimatterPlatformUtils.getBlockFromId(new ResourceLocation(json.get("fill").getAsString())).m_49966_() : null;
        StoneType stoneType = null;
        if (json.has("stoneType") && (stoneType = StoneType.get(json.get("stoneType").getAsString())) == null) {
            throw new IllegalStateException("stone type: " + json.get("stoneType").getAsString() + " does not exist!");
        }
        BlockState stoneState = AntimatterPlatformUtils.getBlockFromId(new ResourceLocation(json.get("stoneState").getAsString())).m_49966_();
        WorldGenStoneLayer stoneLayer = new WorldGenStoneLayer(id, stoneType, stoneState, json.get("weight").getAsInt(), json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE, dims);
        if (!ores.isEmpty()) {
            stoneLayer.addOres(ores.toArray(new StoneLayerOre[0]));
        }
        return stoneLayer;
    }
}

