/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.object;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import muramasa.antimatter.registration.IAntimatterObject;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class WorldGenBase<T extends WorldGenBase<?>>
implements IAntimatterObject {
    private final String id;
    private boolean enabled = true;
    private final Set<ResourceLocation> dimensions;
    private boolean custom;
    public final Class<? extends WorldGenBase<?>> toRegister;

    @SafeVarargs
    public WorldGenBase(String id, Class<? extends WorldGenBase<?>> c, ResourceKey<Level> ... dimensions) {
        this.id = id;
        this.dimensions = (Set)Arrays.stream(dimensions).map(ResourceKey::m_135782_).collect(Collectors.toCollection(ObjectOpenHashSet::new));
        this.toRegister = c;
    }

    public WorldGenBase(String id, Class<? extends WorldGenBase<?>> c, List<ResourceKey<Level>> dimensions) {
        this.id = id;
        this.dimensions = (Set)dimensions.stream().map(ResourceKey::m_135782_).collect(Collectors.toCollection(ObjectOpenHashSet::new));
        this.toRegister = c;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<ResourceLocation> getDims() {
        return this.dimensions;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public WorldGenBase<T> asCustom() {
        this.custom = true;
        return this;
    }

    public WorldGenBase<T> onDataOverride(JsonObject json) {
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        return this;
    }

    public WorldGenBase<T> build() {
        if (this.dimensions == null) {
            throw new IllegalStateException("WorldGenBase - " + this.id + ": dimensions cannot be null");
        }
        return this;
    }

    public Predicate<Holder<Biome>> getValidBiomes() {
        return b -> true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorldGenBase)) {
            return false;
        }
        WorldGenBase other = (WorldGenBase)o;
        return other.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

