/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.feature;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.worldgen.AntimatterConfiguredFeatures;
import muramasa.antimatter.worldgen.feature.AntimatterFeature;
import muramasa.antimatter.worldgen.vein.WorldGenVeinLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FeatureVeinLayer
extends AntimatterFeature<NoneFeatureConfiguration> {
    public FeatureVeinLayer() {
        super(NoneFeatureConfiguration.f_67815_, WorldGenVeinLayer.class);
    }

    @Override
    public String getId() {
        return "feature_vein_layer";
    }

    @Override
    public boolean enabled() {
        return AntimatterConfig.WORLD.ORE_VEINS && this.getRegistry().size() > 0;
    }

    @Override
    public void init() {
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> placer) {
        int chunkX = placer.m_159777_().m_123341_() >> 4;
        int chunkZ = placer.m_159777_().m_123343_() >> 4;
        for (Tuple<Integer, Integer> seed : FeatureVeinLayer.getVeinSeeds(chunkX, chunkZ)) {
            WorldGenVeinLayer.generate(placer.m_159774_(), chunkX, chunkZ, (Integer)seed.m_14418_(), (Integer)seed.m_14419_());
        }
        return true;
    }

    public static List<Tuple<Integer, Integer>> getVeinSeeds(int chunkX, int chunkZ) {
        int westX = chunkX - AntimatterConfig.WORLD.ORE_VEIN_MAX_SIZE / 16;
        int eastX = chunkX + (AntimatterConfig.WORLD.ORE_VEIN_MAX_SIZE / 16 + 1);
        int northZ = chunkZ - AntimatterConfig.WORLD.ORE_VEIN_MAX_SIZE / 16;
        int southZ = chunkZ + (AntimatterConfig.WORLD.ORE_VEIN_MAX_SIZE / 16 + 1);
        ObjectArrayList res = new ObjectArrayList();
        for (int x = westX; x < eastX; ++x) {
            for (int z = northZ; z < southZ; ++z) {
                if (Math.abs(x) % 3 != 1 || Math.abs(z) % 3 != 1) continue;
                res.add(new Tuple((Object)x, (Object)z));
            }
        }
        return res;
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, Biome.BiomeCategory category, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        gen.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, AntimatterConfiguredFeatures.VEIN_LAYER);
    }
}

