/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.feature;

import java.util.BitSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.worldgen.AntimatterConfiguredFeatures;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.WorldGenHelper;
import muramasa.antimatter.worldgen.feature.AntimatterFeature;
import muramasa.antimatter.worldgen.vanillaore.WorldGenVanillaOre;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FeatureVanillaOres
extends AntimatterFeature<NoneFeatureConfiguration> {
    public FeatureVanillaOres() {
        super(NoneFeatureConfiguration.f_67815_, WorldGenVanillaOre.class);
    }

    @Override
    public String getId() {
        return "vanilla_ores";
    }

    @Override
    public boolean enabled() {
        return this.getRegistry().size() > 0;
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, Biome.BiomeCategory category, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        gen.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, AntimatterConfiguredFeatures.VANILLA_ORES);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> placer) {
        Random random = placer.m_159776_();
        BlockPos blockpos = placer.m_159777_();
        WorldGenLevel world = placer.m_159774_();
        int chunkX = placer.m_159777_().m_123341_() >> 4;
        int chunkZ = placer.m_159777_().m_123343_() >> 4;
        int chunkCornerX = chunkX * 16;
        int chunkCornerZ = chunkZ * 16;
        int worldMinY = world.m_6042_().m_156732_();
        int worldMaxY = world.m_6042_().m_156732_() + world.m_6042_().m_156733_();
        List<WorldGenVanillaOre> vanillaOres = AntimatterWorldGenerator.all(WorldGenVanillaOre.class, (ResourceKey<Level>)world.m_6018_().m_46472_());
        int spawned = 0;
        for (WorldGenVanillaOre vanillaOre : vanillaOres) {
            int amountPerChunk;
            if (!vanillaOre.primary.has(vanillaOre.materialType) || vanillaOre.secondary != Material.NULL && !vanillaOre.secondary.has(vanillaOre.secondaryType) || vanillaOre.rare && !(random.nextFloat() < 1.0f / (float)vanillaOre.weight)) continue;
            int minY = Math.max(worldMinY, vanillaOre.minY);
            int maxY = Math.min(worldMaxY, vanillaOre.maxY);
            int j = amountPerChunk = vanillaOre.rare ? 1 : vanillaOre.weight;
            for (int i = 0; i < j; ++i) {
                boolean spawn;
                int y = vanillaOre.triangle ? this.sample(random, minY, maxY) : minY + random.nextInt(Math.max(1, maxY - minY));
                BlockPos spawnPos = new BlockPos(chunkCornerX + random.nextInt(16), y, chunkCornerZ + random.nextInt(16));
                if (!vanillaOre.getValidBiomes().test((Holder<Biome>)world.m_204166_(spawnPos))) continue;
                boolean bl = spawn = vanillaOre.size > 1 ? this.place(world, random, spawnPos, vanillaOre) : this.setOreBlock(world, spawnPos, vanillaOre);
                if (!spawn) continue;
                ++spawned;
            }
        }
        return spawned > 0;
    }

    public boolean place(WorldGenLevel worldgenlevel, Random random, BlockPos blockpos, WorldGenVanillaOre config) {
        float f = random.nextFloat() * (float)Math.PI;
        float f1 = (float)config.size / 8.0f;
        int i = Mth.m_14167_((float)(((float)config.size / 16.0f * 2.0f + 1.0f) / 2.0f));
        double minX = (double)blockpos.m_123341_() + Math.sin(f) * (double)f1;
        double maxX = (double)blockpos.m_123341_() - Math.sin(f) * (double)f1;
        double minZ = (double)blockpos.m_123343_() + Math.cos(f) * (double)f1;
        double maxZ = (double)blockpos.m_123343_() - Math.cos(f) * (double)f1;
        double minY = blockpos.m_123342_() + random.nextInt(3) - 2;
        double maxY = blockpos.m_123342_() + random.nextInt(3) - 2;
        int x = blockpos.m_123341_() - Mth.m_14167_((float)f1) - i;
        int y = blockpos.m_123342_() - 2 - i;
        int z = blockpos.m_123343_() - Mth.m_14167_((float)f1) - i;
        int width = 2 * (Mth.m_14167_((float)f1) + i);
        int height = 2 * (2 + i);
        for (int ix = x; ix <= x + width; ++ix) {
            for (int iz = z; iz <= z + width; ++iz) {
                if (config.spawnOnOceanFloor) {
                    int y2 = worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, ix, iz);
                    double minY0 = y + random.nextInt(3) - 2;
                    double maxY0 = y + random.nextInt(3) - 2;
                    return this.doPlace(worldgenlevel, random, config, minX, maxX, minZ, maxZ, minY0, maxY0, x, y2, z, width, height);
                }
                if (y > worldgenlevel.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, ix, iz)) continue;
                return this.doPlace(worldgenlevel, random, config, minX, maxX, minZ, maxZ, minY, maxY, x, y, z, width, height);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel pLevel, Random pRandom, WorldGenVanillaOre config, double pMinX, double pMaxX, double pMinZ, double pMaxZ, double pMinY, double pMaxY, int pX, int pY, int pZ, int pWidth, int pHeight) {
        int i = 0;
        BitSet bitset = new BitSet(pWidth * pHeight * pWidth);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int size = config.size;
        double[] adouble = new double[size * 4];
        for (int k = 0; k < size; ++k) {
            float f = (float)k / (float)size;
            double lerpX = Mth.m_14139_((double)f, (double)pMinX, (double)pMaxX);
            double lerpY = Mth.m_14139_((double)f, (double)pMinY, (double)pMaxY);
            double lerpZ = Mth.m_14139_((double)f, (double)pMinZ, (double)pMaxZ);
            double d3 = pRandom.nextDouble() * (double)size / 16.0;
            double d4 = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4 + 0] = lerpX;
            adouble[k * 4 + 1] = lerpY;
            adouble[k * 4 + 2] = lerpZ;
            adouble[k * 4 + 3] = d4;
        }
        for (int currentIndex = 0; currentIndex < size - 1; ++currentIndex) {
            if (adouble[currentIndex * 4 + 3] <= 0.0) continue;
            for (int offset = currentIndex + 1; offset < size; ++offset) {
                double d12;
                double d10;
                double d8;
                double d14;
                if (adouble[offset * 4 + 3] <= 0.0 || !((d14 = adouble[currentIndex * 4 + 3] - adouble[offset * 4 + 3]) * d14 > (d8 = adouble[currentIndex * 4 + 0] - adouble[offset * 4 + 0]) * d8 + (d10 = adouble[currentIndex * 4 + 1] - adouble[offset * 4 + 1]) * d10 + (d12 = adouble[currentIndex * 4 + 2] - adouble[offset * 4 + 2]) * d12)) continue;
                if (d14 > 0.0) {
                    adouble[offset * 4 + 3] = -1.0;
                    continue;
                }
                adouble[currentIndex * 4 + 3] = -1.0;
            }
        }
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)pLevel);){
            for (int j4 = 0; j4 < size; ++j4) {
                double d9 = adouble[j4 * 4 + 3];
                if (d9 < 0.0) continue;
                double d11 = adouble[j4 * 4 + 0];
                double d13 = adouble[j4 * 4 + 1];
                double d15 = adouble[j4 * 4 + 2];
                int k4 = Math.max(Mth.m_14107_((double)(d11 - d9)), pX);
                int l = Math.max(Mth.m_14107_((double)(d13 - d9)), pY);
                int i1 = Math.max(Mth.m_14107_((double)(d15 - d9)), pZ);
                int j1 = Math.max(Mth.m_14107_((double)(d11 + d9)), k4);
                int k1 = Math.max(Mth.m_14107_((double)(d13 + d9)), l);
                int l1 = Math.max(Mth.m_14107_((double)(d15 + d9)), i1);
                for (int rx = k4; rx <= j1; ++rx) {
                    double d5 = ((double)rx + 0.5 - d11) / d9;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int ry = l; ry <= k1; ++ry) {
                        double d6 = ((double)ry + 0.5 - d13) / d9;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        for (int rz = i1; rz <= l1; ++rz) {
                            LevelChunkSection levelchunksection;
                            int l2;
                            double d7 = ((double)rz + 0.5 - d15) / d9;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || pLevel.m_151562_(ry) || bitset.get(l2 = rx - pX + (ry - pY) * pWidth + (rz - pZ) * pWidth * pHeight)) continue;
                            bitset.set(l2);
                            blockpos$mutableblockpos.m_122178_(rx, ry, rz);
                            if (!pLevel.m_180807_((BlockPos)blockpos$mutableblockpos) || (levelchunksection = bulksectionaccess.m_156104_((BlockPos)blockpos$mutableblockpos)) == null) continue;
                            int lx = SectionPos.m_123207_((int)rx);
                            int ly = SectionPos.m_123207_((int)ry);
                            int lz = SectionPos.m_123207_((int)rz);
                            BlockState blockstate = levelchunksection.m_62982_(lx, ly, lz);
                            Material mat = config.primary;
                            MaterialType<?> type = config.materialType;
                            if (config.secondary != Material.NULL && config.secondaryChance > 0.0f && config.secondaryChance < 1.0f && pRandom.nextFloat() < config.secondaryChance) {
                                mat = config.secondary;
                                if (config.secondaryType != config.materialType) {
                                    type = config.secondaryType;
                                }
                            }
                            if (!this.placeOre(lx, ly, lz, levelchunksection, arg_0 -> ((BulkSectionAccess)bulksectionaccess).m_156110_(arg_0), pRandom, config, mat, type, blockpos$mutableblockpos)) continue;
                            ++i;
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    private int sample(Random random, int minY, int maxY) {
        if (minY > maxY) {
            Antimatter.LOGGER.warn("Empty height range: {}", (Object)this);
            return minY;
        }
        int difference = maxY - minY;
        if (0 >= difference) {
            return Mth.m_144928_((Random)random, (int)minY, (int)maxY);
        }
        int l = difference / 2;
        int m = difference - l;
        return minY + Mth.m_144928_((Random)random, (int)0, (int)m) + Mth.m_144928_((Random)random, (int)0, (int)l);
    }

    private boolean setOreBlock(WorldGenLevel level, BlockPos pos, WorldGenVanillaOre vanillaOre) {
        Holder biome = level.m_204166_(pos);
        ResourceLocation biomeKey = ((ResourceKey)biome.m_203543_().get()).m_135782_();
        if (vanillaOre.biomes.contains(biomeKey) == vanillaOre.biomeBlacklist) {
            return false;
        }
        Material material = vanillaOre.primary;
        MaterialType<?> type = vanillaOre.materialType;
        if (vanillaOre.secondaryChance > 0.0f && vanillaOre.secondary != Material.NULL && level.m_5822_().nextFloat() < vanillaOre.secondaryChance) {
            material = vanillaOre.secondary;
            if (vanillaOre.secondaryType != vanillaOre.materialType) {
                type = vanillaOre.secondaryType;
            }
        }
        return WorldGenHelper.setOre((LevelAccessor)level, pos, material, type);
    }

    public static BlockState getOre(BlockState existing, Material material, MaterialType<?> type) {
        BlockState oreState;
        StoneType stone = (StoneType)WorldGenHelper.STONE_MAP.get((Object)existing);
        if (stone == null || !stone.generateOre) {
            return null;
        }
        Object obj = type.get();
        if (obj instanceof MaterialTypeBlock.IOreGetter) {
            MaterialTypeBlock.IOreGetter getter = (MaterialTypeBlock.IOreGetter)obj;
            v0 = getter.get(material, stone).asState();
        } else {
            obj = type.get();
            if (obj instanceof MaterialTypeBlock.IBlockGetter) {
                MaterialTypeBlock.IBlockGetter getter = (MaterialTypeBlock.IBlockGetter)obj;
                v0 = getter.get(material).asState();
            } else {
                v0 = oreState = null;
            }
        }
        if (existing == null || type.get() instanceof MaterialTypeBlock.IOreGetter && !WorldGenHelper.ORE_PREDICATE.test(existing)) {
            return null;
        }
        return oreState;
    }

    public boolean placeOre(int x, int y, int z, LevelChunkSection chunkSection, Function<BlockPos, BlockState> adjacentStateAccessor, Random random, WorldGenVanillaOre config, Material material, MaterialType<?> type, BlockPos.MutableBlockPos mutable) {
        BlockState blockState = chunkSection.m_62982_(x, y, z);
        BlockState oreToPlace = FeatureVanillaOres.getOre(blockState, material, type);
        if (oreToPlace != null && FeatureVanillaOres.canPlaceOre(blockState, adjacentStateAccessor, random, config, material, type, mutable)) {
            chunkSection.m_62991_(x, y, z, oreToPlace, false);
            return true;
        }
        return false;
    }

    public static boolean canPlaceOre(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, Random random, WorldGenVanillaOre config, Material material, MaterialType<?> type, BlockPos.MutableBlockPos mutable) {
        if (FeatureVanillaOres.getOre(state, material, type) == null) {
            return false;
        }
        if (FeatureVanillaOres.shouldSkipAirCheck(random, config.discardOnExposureChance)) {
            return true;
        }
        return !FeatureVanillaOres.m_159750_(adjacentStateAccessor, (BlockPos)mutable);
    }

    protected static boolean shouldSkipAirCheck(Random pRandom, float pChance) {
        if (pChance <= 0.0f) {
            return true;
        }
        if (pChance >= 1.0f) {
            return false;
        }
        return pRandom.nextFloat() >= pChance;
    }
}

