/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.feature;

import java.util.List;
import java.util.Random;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.worldgen.AntimatterConfiguredFeatures;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.NoiseGenerator;
import muramasa.antimatter.worldgen.StoneLayerOre;
import muramasa.antimatter.worldgen.WorldGenHelper;
import muramasa.antimatter.worldgen.feature.AntimatterFeature;
import muramasa.antimatter.worldgen.object.WorldGenStoneLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FeatureStoneLayer
extends AntimatterFeature<NoneFeatureConfiguration> {
    public FeatureStoneLayer() {
        super(NoneFeatureConfiguration.f_67815_, WorldGenStoneLayer.class);
    }

    @Override
    public String getId() {
        return "feature_stone_layer";
    }

    @Override
    public boolean enabled() {
        return AntimatterConfig.WORLD.STONE_LAYERS && this.getRegistry().size() > 0;
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, Biome.BiomeCategory category, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        gen.m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, AntimatterConfiguredFeatures.STONE_LAYER);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctxt) {
        WorldGenLevel world = ctxt.m_159774_();
        BlockPos pos = ctxt.m_159777_();
        Random rand = ctxt.m_159776_();
        List<WorldGenStoneLayer> stones = AntimatterWorldGenerator.all(WorldGenStoneLayer.class, (ResourceKey<Level>)world.m_6018_().m_46472_());
        if (stones.size() == 0) {
            return false;
        }
        WorldGenStoneLayer[] layers = new WorldGenStoneLayer[7];
        NoiseGenerator noise = new NoiseGenerator(world);
        int stonesSize = stones.size();
        int stonesMax = stonesSize - 1;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int tX = pos.m_123341_() + i;
                int tZ = pos.m_123343_() + j;
                layers[0] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, -2.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[1] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, -1.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[2] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 0.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[3] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 1.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[4] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 2.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[5] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 3.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                layers[6] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, 4.0f, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                int maxHeight = world.m_5452_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_142082_(i, 0, j)).m_123342_() + 1;
                for (int tY = -63; tY < maxHeight; ++tY) {
                    BlockState below;
                    int offsetY = tY + 64;
                    Material lastMaterial = null;
                    BlockPos offset = pos.m_142082_(i, offsetY, j);
                    BlockState existing = world.m_8055_(offset);
                    boolean isAir = existing.m_60795_();
                    if (!isAir && existing != layers[3].getStoneState() && layers[3].getStoneState().m_60734_() != Blocks.f_50069_ && layers[3].getStoneState().m_60734_() != Blocks.f_152550_ && WorldGenHelper.setStone((LevelAccessor)world, offset, existing, layers[3].getStoneState())) {
                        Material material = lastMaterial = layers[3].getStoneType() != null ? layers[3].getStoneType().getMaterial() : null;
                    }
                    if (!isAir && AntimatterConfig.WORLD.STONE_LAYER_ORES) {
                        if (layers[1] == layers[5]) {
                            for (StoneLayerOre ore : layers[3].getOres()) {
                                if (!ore.canPlace(offset, rand) || !WorldGenHelper.addOre((LevelAccessor)world, offset, ore.getMaterial(), layers[0] == layers[6])) continue;
                                lastMaterial = ore.getMaterial();
                                break;
                            }
                        } else {
                            for (StoneLayerOre ore : WorldGenStoneLayer.getCollision(layers[3].getStoneType(), layers[5].getStoneState(), layers[1].getStoneState())) {
                                if (!ore.canPlace(offset, rand) || !WorldGenHelper.addOre((LevelAccessor)world, offset, ore.getMaterial(), true)) continue;
                                lastMaterial = ore.getMaterial();
                                break;
                            }
                        }
                    }
                    if ((isAir || WorldGenHelper.ROCK_SET.contains((Object)existing)) && lastMaterial != null && !(below = world.m_8055_(offset.m_142082_(0, -1, 0))).m_60795_() && below != WorldGenHelper.WATER_STATE) {
                        WorldGenHelper.setRock((LevelAccessor)world, offset, lastMaterial, below, AntimatterConfig.WORLD.STONE_LAYER_ROCK_CHANCE);
                    }
                    System.arraycopy(layers, 1, layers, 0, layers.length - 1);
                    layers[6] = stones.get(Math.min(stonesMax, (int)((noise.get(tX, offsetY + 4, tZ) + 1.0f) / 2.0f * (float)stonesSize)));
                }
            }
        }
        return true;
    }
}

