/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen.feature;

import java.util.List;
import java.util.Random;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.worldgen.AntimatterConfiguredFeatures;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import muramasa.antimatter.worldgen.WorldGenHelper;
import muramasa.antimatter.worldgen.feature.AntimatterFeature;
import muramasa.antimatter.worldgen.smallore.WorldGenSmallOre;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class FeatureSmallOres
extends AntimatterFeature<NoneFeatureConfiguration> {
    public FeatureSmallOres() {
        super(NoneFeatureConfiguration.f_67815_, WorldGenSmallOre.class);
    }

    @Override
    public String getId() {
        return "small_ores";
    }

    @Override
    public boolean enabled() {
        return AntimatterConfig.WORLD.SMALL_ORES && this.getRegistry().size() > 0;
    }

    @Override
    public void init() {
    }

    @Override
    public void build(ResourceLocation name, Biome.ClimateSettings climate, Biome.BiomeCategory category, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        gen.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, AntimatterConfiguredFeatures.SMALL_ORES);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> placer) {
        Random random = placer.m_159776_();
        BlockPos blockpos = placer.m_159777_();
        WorldGenLevel world = placer.m_159774_();
        int chunkX = placer.m_159777_().m_123341_() >> 4;
        int chunkZ = placer.m_159777_().m_123343_() >> 4;
        int chunkCornerX = chunkX * 16;
        int chunkCornerZ = chunkZ * 16;
        int worldMinY = world.m_6042_().m_156732_();
        int worldMaxY = world.m_6042_().m_156732_() + world.m_6042_().m_156733_();
        List<WorldGenSmallOre> smallOres = AntimatterWorldGenerator.all(WorldGenSmallOre.class, (ResourceKey<Level>)world.m_6018_().m_46472_());
        int spawned = 0;
        for (WorldGenSmallOre smallOre : smallOres) {
            if (!smallOre.material.has(AntimatterMaterialTypes.ORE_SMALL)) continue;
            int minY = Math.max(worldMinY, smallOre.minY);
            int maxY = Math.min(worldMaxY, smallOre.maxY);
            int j = Math.max(1, smallOre.amountPerChunk / 2 + random.nextInt(smallOre.amountPerChunk) / 2);
            for (int i = 0; i < j; ++i) {
                boolean spawn;
                BlockPos pos = new BlockPos(chunkCornerX + random.nextInt(16), minY + random.nextInt(Math.max(1, maxY - minY)), chunkCornerZ + random.nextInt(16));
                if (!smallOre.getValidBiomes().test((Holder<Biome>)world.m_204166_(pos)) || !(spawn = this.setOreBlock(world, pos, smallOre))) continue;
                ++spawned;
            }
        }
        return spawned > 0;
    }

    private boolean setOreBlock(WorldGenLevel level, BlockPos pos, WorldGenSmallOre smallOre) {
        Holder biome = level.m_204166_(pos);
        ResourceLocation biomeKey = ((ResourceKey)biome.m_203543_().get()).m_135782_();
        if (smallOre.biomes.contains(biomeKey) == smallOre.biomeBlacklist) {
            return false;
        }
        return WorldGenHelper.setOre((LevelAccessor)level, pos, smallOre.material, AntimatterMaterialTypes.ORE_SMALL);
    }
}

