/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.worldgen.feature.FeatureOre;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class WorldGenHelper {
    public static Object2ObjectOpenHashMap<BlockState, StoneType> STONE_MAP = new Object2ObjectOpenHashMap();
    public static ObjectOpenHashSet<BlockState> ROCK_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<BlockState> STONE_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<BlockState> TREE_SET = new ObjectOpenHashSet();
    public static ObjectOpenHashSet<String> TREE_BIOME_SET = new ObjectOpenHashSet();
    public static BlockState STONE_STATE = Blocks.f_50069_.m_49966_();
    public static BlockState WATER_STATE = Blocks.f_49990_.m_49966_();
    public static Predicate<BlockState> ORE_PREDICATE = state -> STONE_MAP.containsKey(state);
    public static Predicate<BlockState> ROCK_PREDICATE = state -> ROCK_SET.contains(state);
    public static Predicate<BlockState> STONE_PREDICATE = state -> STONE_SET.contains(state);

    public static void init() {
        AntimatterAPI.all(StoneType.class).forEach(t -> STONE_MAP.put((Object)t.getState(), t));
        ROCK_SET.add((Object)Blocks.f_50016_.m_49966_());
        ROCK_SET.add((Object)Blocks.f_49990_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50069_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50122_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50334_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50228_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50259_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50134_.m_49966_());
        STONE_SET.add((Object)Blocks.f_152550_.m_49966_());
        STONE_SET.add((Object)Blocks.f_152496_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49997_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49996_.m_49966_());
        STONE_SET.add((Object)Blocks.f_49995_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50089_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50264_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50059_.m_49966_());
        STONE_SET.add((Object)Blocks.f_50173_.m_49966_());
        TREE_SET.add((Object)Blocks.f_50034_.m_49966_());
        TREE_BIOME_SET.add((Object)"Forest");
        TREE_BIOME_SET.add((Object)"ForestHills");
    }

    public static boolean setState(LevelAccessor world, BlockPos pos, BlockState state) {
        if (state == null) {
            Antimatter.LOGGER.error("WorldGenHelper: tried to place null state at " + pos.toString());
            return false;
        }
        return world.m_7731_(pos, state, 0);
    }

    public static boolean setOre(LevelAccessor world, BlockPos pos, BlockState existing, Material material, MaterialType<?> type) {
        BlockState oreState;
        StoneType stone = (StoneType)STONE_MAP.get((Object)existing);
        if (stone == null || !stone.generateOre) {
            return false;
        }
        BlockState blockState = oreState = type == AntimatterMaterialTypes.ORE ? ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE.get()).get(material, stone).asState() : ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE_SMALL.get()).get(material, stone).asState();
        if (!ORE_PREDICATE.test(existing)) {
            return false;
        }
        return WorldGenHelper.setState(world, pos, oreState);
    }

    public static boolean setOre(LevelAccessor world, BlockPos pos, Material material, MaterialType<?> type) {
        BlockState existing = world.m_8055_(pos);
        return WorldGenHelper.setOre(world, pos, existing, material, type);
    }

    public static boolean addOre(LevelAccessor world, BlockPos pos, Material material, boolean normalOre) {
        ((List)FeatureOre.ORES.computeIfAbsent((Object)world.m_46865_(pos).m_7697_(), k -> new ObjectArrayList())).add(new ImmutableTriple((Object)pos, (Object)material, (Object)normalOre));
        return true;
    }

    public static boolean addRock(LevelAccessor world, BlockPos pos, Material material, int chance) {
        int y = Math.min(world.m_6924_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_(), pos.m_123343_()), world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_()));
        BlockState state = world.m_8055_(new BlockPos(pos.m_123341_(), y - 1, pos.m_123343_()));
        return WorldGenHelper.setRock(world, new BlockPos(pos.m_123341_(), y, pos.m_123343_()), material, state, chance);
    }

    public static boolean setRock(LevelAccessor world, BlockPos pos, Material material, @Nullable BlockState fill, int chance) {
        if (world.m_5822_().nextInt(chance) != 0) {
            return false;
        }
        StoneType stone = fill != null ? (StoneType)STONE_MAP.get((Object)fill) : null;
        BlockState rockState = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ROCK.get()).get(material, stone != null && stone.generateOre ? stone : AntimatterStoneTypes.STONE).asState();
        BlockState existingBelow = world.m_8055_(pos.m_7495_());
        if (existingBelow.m_60795_() || !existingBelow.m_60767_().m_76333_()) {
            return false;
        }
        BlockState existing = world.m_8055_(pos);
        if (!ROCK_PREDICATE.test(existing)) {
            return false;
        }
        if (existing == WATER_STATE) {
            rockState = WorldGenHelper.waterLogState(rockState);
        }
        return WorldGenHelper.setState(world, pos, rockState);
    }

    public static boolean setStone(LevelAccessor world, BlockPos pos, BlockState existing, BlockState replacement) {
        if (!STONE_PREDICATE.test(existing)) {
            return false;
        }
        return WorldGenHelper.setState(world, pos, replacement);
    }

    public static BlockState waterLogState(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : state;
    }
}

