/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen;

import com.google.gson.JsonObject;
import java.util.Random;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.StoneType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class StoneLayerOre {
    private final Material material;
    private StoneType stoneType;
    private BlockState oreState;
    private BlockState oreSmallState;
    private final int chance;
    private final int minY;
    private final int maxY;

    public StoneLayerOre(Material material, int chance, int minY, int maxY) {
        this.material = material;
        this.chance = StoneLayerOre.bind(1, 3628800, chance);
        this.minY = minY;
        this.maxY = maxY;
    }

    public StoneLayerOre setStatesByStoneType(StoneType stoneType) {
        this.oreState = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE.get()).get(this.material, stoneType).asState();
        this.oreSmallState = ((MaterialTypeBlock.IOreGetter)AntimatterMaterialTypes.ORE_SMALL.get()).get(this.material, stoneType).asState();
        this.stoneType = stoneType;
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    public StoneType getStoneType() {
        return this.stoneType;
    }

    public BlockState getOreState() {
        return this.oreState;
    }

    public BlockState getOreSmallState() {
        return this.oreSmallState;
    }

    public int getChance() {
        return this.chance;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public boolean canPlace(BlockPos pos, Random rand) {
        return pos.m_123342_() >= this.minY && pos.m_123342_() <= this.maxY && rand.nextInt(3628800) < this.chance;
    }

    public static int bind(int min, int max, int boundValue) {
        return min > max ? Math.max(max, Math.min(min, boundValue)) : Math.max(min, Math.min(max, boundValue));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("chance", (Number)this.chance);
        json.addProperty("material", this.material.getId());
        if (this.minY > Integer.MIN_VALUE) {
            json.addProperty("minY", (Number)this.minY);
        }
        if (this.maxY < Integer.MAX_VALUE) {
            json.addProperty("maxY", (Number)this.maxY);
        }
        if (this.stoneType != null) {
            json.addProperty("stoneType", this.stoneType.getId());
        }
        return json;
    }

    public static StoneLayerOre fromJson(JsonObject json) {
        StoneType stoneType = null;
        if (json.has("stoneType") && (stoneType = StoneType.get(json.get("stoneType").getAsString())) == null) {
            throw new IllegalStateException("stone type: " + json.get("stoneType").getAsString() + " does not exist!");
        }
        StoneLayerOre stoneLayerOre = new StoneLayerOre(Material.get(json.get("material").getAsString()), json.get("chance").getAsInt(), json.has("minY") ? json.get("minY").getAsInt() : Integer.MIN_VALUE, json.has("maxY") ? json.get("maxY").getAsInt() : Integer.MAX_VALUE);
        if (stoneType != null) {
            stoneLayerOre.setStatesByStoneType(stoneType);
        }
        return stoneLayerOre;
    }
}

