/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.worldgen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.Ref;
import muramasa.antimatter.mixin.BiomeGenerationBuilderAccessor;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import muramasa.antimatter.worldgen.WorldGenHelper;
import muramasa.antimatter.worldgen.feature.AntimatterFeature;
import muramasa.antimatter.worldgen.feature.FeatureOre;
import muramasa.antimatter.worldgen.feature.FeatureSmallOres;
import muramasa.antimatter.worldgen.feature.FeatureStoneLayer;
import muramasa.antimatter.worldgen.feature.FeatureVanillaOres;
import muramasa.antimatter.worldgen.feature.FeatureVein;
import muramasa.antimatter.worldgen.feature.FeatureVeinLayer;
import muramasa.antimatter.worldgen.feature.IAntimatterFeature;
import muramasa.antimatter.worldgen.object.WorldGenBase;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AntimatterWorldGenerator {
    static final AntimatterFeature<NoneFeatureConfiguration> VEIN = new FeatureVein();
    static final AntimatterFeature<NoneFeatureConfiguration> SMALL_ORE = new FeatureSmallOres();
    static final AntimatterFeature<NoneFeatureConfiguration> VANILLA_ORE = new FeatureVanillaOres();
    static final AntimatterFeature<NoneFeatureConfiguration> VEIN_LAYER = new FeatureVeinLayer();
    static final AntimatterFeature<NoneFeatureConfiguration> ORE = new FeatureOre();
    static final AntimatterFeature<NoneFeatureConfiguration> STONE_LAYER = new FeatureStoneLayer();

    public static void clear() {
        AntimatterAPI.all(AntimatterFeature.class, (T t) -> t.getRegistry().clear());
    }

    public static void preinit() {
    }

    public static void init() {
        AntimatterAPI.runLaterCommon(() -> {
            WorldGenHelper.init();
            try {
                AntimatterAPI.all(AntimatterFeature.class).stream().filter(AntimatterFeature::enabled).forEach(f -> {
                    f.onDataOverride(new JsonObject());
                    f.init();
                });
            }
            catch (Exception ex) {
                Antimatter.LOGGER.warn("Caught exception during World generator later init: " + ex.toString());
            }
        });
    }

    public static void setup() {
        Antimatter.LOGGER.info("AntimatterAPI WorldGen Initialization Stage...");
        AntimatterAPI.onRegistration(RegistrationEvent.WORLDGEN_INIT);
    }

    public static void register(Class<?> c, WorldGenBase<?> base) {
        AntimatterFeature feature = AntimatterAPI.get(AntimatterFeature.class, c.getName());
        if (feature != null) {
            base.getDims().forEach(d -> ((List)feature.getRegistry().computeIfAbsent(d, k -> new LinkedList())).add(base));
        }
    }

    public static void register(BiomeLoadEvent consumer, String id, String domain, Predicate<Biome.BiomeCategory> validator) {
        AntimatterAPI.register(GenHandler.class, id, domain, new GenHandler(consumer, validator));
    }

    public static <T> List<T> all(Class<T> c, ResourceKey<Level> dim) {
        AntimatterFeature feat = AntimatterAPI.get(AntimatterFeature.class, c.getName());
        return feat != null ? ((List)feat.getRegistry().computeIfAbsent((Object)dim.m_135782_(), k -> new LinkedList())).stream().map(c::cast).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static void removeStoneFeatures(BiomeGenerationSettings.Builder builder) {
        AntimatterWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_50334_.m_49966_(), Blocks.f_50122_.m_49966_(), Blocks.f_50228_.m_49966_(), Blocks.f_152496_.m_49966_(), Blocks.f_50493_.m_49966_(), Blocks.f_49994_.m_49966_());
    }

    private static void removeOreFeatures(BiomeGenerationSettings.Builder builder) {
        AntimatterWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_49997_.m_49966_(), Blocks.f_49996_.m_49966_(), Blocks.f_49995_.m_49966_(), Blocks.f_152505_.m_49966_(), Blocks.f_50264_.m_49966_(), Blocks.f_50173_.m_49966_(), Blocks.f_50059_.m_49966_(), Blocks.f_50089_.m_49966_());
        AntimatterWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_65731_, Blocks.f_152469_.m_49966_(), Blocks.f_152468_.m_49966_(), Blocks.f_152467_.m_49966_(), Blocks.f_152506_.m_49966_(), Blocks.f_152479_.m_49966_(), Blocks.f_152473_.m_49966_(), Blocks.f_152472_.m_49966_(), Blocks.f_152474_.m_49966_());
        AntimatterWorldGenerator.removeDecoratedFeatureFromAllBiomes(builder, GenerationStep.Decoration.UNDERGROUND_ORES, Feature.f_159727_, Blocks.f_49996_.m_49966_(), Blocks.f_152505_.m_49966_(), Blocks.f_152468_.m_49966_(), Blocks.f_152506_.m_49966_());
    }

    public static void removeDecoratedFeatureFromAllBiomes(BiomeGenerationSettings.Builder builder, @Nonnull GenerationStep.Decoration stage, @Nonnull Feature<?> featureToRemove, BlockState ... states) {
        if (states.length == 0) {
            Utils.onInvalidData("No BlockStates specified to be removed!");
        }
        Set<BlockState> set = Set.of(states);
        ((BiomeGenerationBuilderAccessor)builder).getFeatures().get(stage.ordinal()).removeIf(f -> AntimatterWorldGenerator.isDecoratedFeatureDisabled((ConfiguredFeature)((PlacedFeature)f.m_203334_()).f_191775_().m_203334_(), featureToRemove, set));
    }

    public static void removeDecoratedFeaturesFromBiome(@Nonnull Biome biome, @Nonnull GenerationStep.Decoration stage, @Nonnull Feature<?> featureToRemove, BlockState ... states) {
        if (states.length == 0) {
            Utils.onInvalidData("No BlockStates specified to be removed!");
        }
        AntimatterAPI.runLaterCommon(() -> {
            for (BlockState blockState : states) {
            }
        });
    }

    public static boolean isDecoratedFeatureDisabled(@Nonnull ConfiguredFeature<?, ?> configuredFeature, @Nonnull Feature<?> featureToRemove, @Nonnull Set<BlockState> state) {
        FeatureConfiguration featureConfiguration = configuredFeature.f_65378_();
        if (featureConfiguration instanceof OreConfiguration) {
            OreConfiguration config = (OreConfiguration)featureConfiguration;
            return config.f_161005_.stream().anyMatch(t -> state.contains(t.f_161033_));
        }
        return false;
    }

    public static void reloadEvent(ResourceLocation name, Biome.ClimateSettings climate, Biome.BiomeCategory category, BiomeSpecialEffects effects, BiomeGenerationSettings.Builder gen, MobSpawnSettings.Builder spawns) {
        AntimatterAPI.all(IAntimatterFeature.class, (T t) -> t.build(name, climate, category, effects, gen, spawns));
        AntimatterAPI.all(GenHandler.class, (T t) -> {
            if (name == null) {
                return;
            }
            if (t.validator.test(category)) {
                t.consumer.accept(name, climate, category, effects, gen, spawns);
            }
        });
        if (AntimatterPlatformUtils.isForge()) {
            AntimatterWorldGenerator.handleFeatureRemoval(gen);
        }
    }

    private static void handleFeatureRemoval(BiomeGenerationSettings.Builder gen) {
        if (AntimatterConfig.WORLD.VANILLA_ORE_GEN) {
            AntimatterWorldGenerator.removeOreFeatures(gen);
        }
        if (AntimatterConfig.WORLD.VANILLA_STONE_GEN) {
            AntimatterWorldGenerator.removeStoneFeatures(gen);
        }
    }

    public static void writeJson(JsonObject json, String id, String path) {
        File dir = new File(AntimatterPlatformUtils.getConfigDir().toFile(), "antimatter/" + path + "/default");
        File target = new File(dir, id + ".json");
        File readme = new File(dir, "README.txt");
        try {
            BufferedWriter writer;
            dir.mkdirs();
            if (!readme.exists()) {
                writer = Files.newBufferedWriter(readme.toPath(), new OpenOption[0]);
                writer.write("This directory is used for default " + path + "worldgen, to override an entry copy the json to the overrides folder and modify it there.");
                writer.close();
            }
            writer = Files.newBufferedWriter(target.toPath(), new OpenOption[0]);
            writer.write(Ref.GSON.toJson((JsonElement)json));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T extends IAntimatterObject> T readJson(Class<T> clazz, T original, BiFunction<String, JsonObject, T> function, String path) {
        File dir = new File(AntimatterPlatformUtils.getConfigDir().toFile(), "antimatter/" + path + "/overrides");
        File target = new File(dir, original.getId() + ".json");
        if (target.exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(target.toPath());
                JsonObject parsed = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                IAntimatterObject read = (IAntimatterObject)function.apply(original.getId(), parsed);
                ((Reader)reader).close();
                return (T)read;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return original;
    }

    protected record GenHandler(BiomeLoadEvent consumer, Predicate<Biome.BiomeCategory> validator) {
    }

    @FunctionalInterface
    public static interface BiomeLoadEvent {
        public void accept(ResourceLocation var1, Biome.ClimateSettings var2, Biome.BiomeCategory var3, BiomeSpecialEffects var4, BiomeGenerationSettings.Builder var5, MobSpawnSettings.Builder var6);
    }
}

