/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.LazyOptional;

public class LazyHolder<T> {
    private final Supplier<T> value;
    private AtomicReference<T> resolvedValue;
    private LazyOptional<T> optionalDelegate;

    public static <T> LazyHolder<T> of(@Nullable Supplier<T> value) {
        return value == null ? LazyHolder.empty() : new LazyHolder<T>(value);
    }

    public static <T> LazyHolder<T> empty() {
        return new LazyHolder<T>();
    }

    private LazyHolder() {
        this(null);
    }

    private LazyHolder(Supplier<T> value) {
        this.value = value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    @Nullable
    public T get() {
        if (this.resolvedValue == null) {
            this.resolvedValue = this.value == null ? new AtomicReference<Object>(null) : new AtomicReference<T>(this.value.get());
        }
        return this.resolvedValue.get();
    }

    public LazyOptional<T> transform() {
        if (this.optionalDelegate == null) {
            Object value = this.get();
            this.optionalDelegate = value == null ? LazyOptional.empty() : LazyOptional.of(() -> value);
            return this.optionalDelegate;
        }
        return this.optionalDelegate;
    }

    public T orElse(T orElse) {
        T value = this.get();
        return value == null ? orElse : value;
    }

    public T orElseGet(Supplier<T> orElse) {
        T value = this.get();
        return value == null ? orElse.get() : value;
    }

    public T orElseRetrieve(Supplier<Supplier<T>> orElse) {
        T value = this.get();
        return value == null ? orElse.get().get() : value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<X> throwable) throws X {
        T value = this.get();
        if (value != null) {
            return value;
        }
        throw (Throwable)throwable.get();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        T value = this.get();
        if (value != null) {
            consumer.accept(value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> consumer, Runnable runnable) {
        T value = this.get();
        if (value != null) {
            consumer.accept(value);
        } else {
            runnable.run();
        }
    }

    public <X extends Throwable> void ifPresentOrThrow(Consumer<? super T> consumer, Supplier<X> throwable) throws X {
        T value = this.get();
        if (value == null) {
            throw (Throwable)throwable.get();
        }
        consumer.accept(value);
    }

    public <U> LazyHolder<U> map(Function<? super T, ? extends U> mapper) {
        Object value = this.get();
        return value == null ? LazyHolder.empty() : LazyHolder.of(() -> mapper.apply((Object)value));
    }

    public LazyHolder<T> filter(Predicate<? super T> predicate) {
        T value = this.get();
        return value != null && predicate.test(value) ? this : LazyHolder.empty();
    }
}

