/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.behaviour;

import muramasa.antimatter.behaviour.IItemUse;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.behaviour.BehaviourUtil;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BehaviourVanillaShovel
implements IItemUse<IAntimatterTool> {
    public static final BehaviourVanillaShovel INSTANCE = new BehaviourVanillaShovel();

    @Override
    public String getId() {
        return "vanilla_shovel";
    }

    @Override
    public InteractionResult onItemUse(IAntimatterTool instance, UseOnContext c) {
        if (c.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        BlockState state = c.m_43725_().m_8055_(c.m_8083_());
        BlockState changedState = null;
        if (state.m_60734_() == Blocks.f_50440_ && c.m_43725_().m_46859_(c.m_8083_().m_7494_())) {
            changedState = this.getToolModifiedState(state, Blocks.f_152481_.m_49966_(), c.m_43725_(), c.m_8083_(), c.m_43723_(), c.m_43722_(), "shovel_flatten");
            if (changedState != null) {
                SoundEvent soundEvent = instance.getAntimatterToolType().getUseSound() == null ? SoundEvents.f_12406_ : instance.getAntimatterToolType().getUseSound();
                c.m_43725_().m_5594_(c.m_43723_(), c.m_8083_(), soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() && (changedState = this.getToolModifiedState(state, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), c.m_43725_(), c.m_8083_(), c.m_43723_(), c.m_43722_(), "shovel_dig")) != null) {
            c.m_43725_().m_5898_(c.m_43723_(), 1009, c.m_8083_(), 0);
        }
        if (changedState != null) {
            c.m_43725_().m_7731_(c.m_8083_(), changedState, 11);
            Utils.damageStack(c.m_43722_(), (LivingEntity)c.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getToolModifiedState(BlockState originalState, BlockState changedState, Level world, BlockPos pos, Player player, ItemStack stack, String action) {
        BlockState eventState = BehaviourUtil.onToolUse(originalState, world, pos, player, stack, action);
        return eventState != originalState ? eventState : changedState;
    }
}

