/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.behaviour;

import javax.annotation.Nullable;
import muramasa.antimatter.behaviour.IItemUse;
import muramasa.antimatter.tool.IAntimatterTool;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BehaviourTorchPlacing
implements IItemUse<IAntimatterTool> {
    public static final BehaviourTorchPlacing INSTANCE = new BehaviourTorchPlacing();

    @Override
    public String getId() {
        return "torch_placing";
    }

    @Override
    public InteractionResult onItemUse(IAntimatterTool instance, UseOnContext c) {
        InteractionResult resultType;
        ItemStack stack = ItemStack.f_41583_;
        if (c.m_43723_() == null) {
            return InteractionResult.PASS;
        }
        for (ItemStack stack1 : c.m_43723_().m_150109_().f_35974_) {
            if (stack1.m_41720_() != Items.f_42000_ && stack1.m_41720_() != Items.f_42053_) continue;
            stack = stack1;
            break;
        }
        if ((!stack.m_41619_() || c.m_43723_().m_7500_()) && (resultType = this.tryPlace(new BlockPlaceContext(c), stack)).m_19077_()) {
            if (!c.m_43723_().m_7500_()) {
                stack.m_41774_(1);
            }
            return resultType;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult tryPlace(BlockPlaceContext context, ItemStack torch) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getStateForPlacement(context, torch);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerentity = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockState blockstate1 = world.m_8055_(blockpos);
        Block block = blockstate1.m_60734_();
        if (block == blockstate.m_60734_()) {
            blockstate1 = this.updateBlockStateFromTag(blockpos, world, itemstack, blockstate1);
            this.onBlockPlaced(blockpos, world, playerentity, itemstack, blockstate1);
            block.m_6402_(world, blockpos, blockstate1, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = blockstate1.m_60827_();
        world.m_5594_(playerentity, blockpos, Blocks.f_50081_.m_49962_(blockstate1).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected boolean onBlockPlaced(BlockPos pos, Level worldIn, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.m_40582_((Level)worldIn, (Player)player, (BlockPos)pos, (ItemStack)stack);
    }

    private BlockState updateBlockStateFromTag(BlockPos p_219985_1_, Level p_219985_2_, ItemStack p_219985_3_, BlockState p_219985_4_) {
        BlockState blockstate = p_219985_4_;
        CompoundTag compoundnbt = p_219985_3_.m_41783_();
        if (compoundnbt != null) {
            CompoundTag compoundnbt1 = compoundnbt.m_128469_("BlockStateTag");
            StateDefinition statecontainer = p_219985_4_.m_60734_().m_49965_();
            for (String s : compoundnbt1.m_128431_()) {
                Property property = statecontainer.m_61081_(s);
                if (property == null) continue;
                String s1 = compoundnbt1.m_128423_(s).m_7916_();
                blockstate = BehaviourTorchPlacing.updateState(blockstate, property, s1);
            }
        }
        if (blockstate != p_219985_4_) {
            p_219985_2_.m_7731_(p_219985_1_, blockstate, 2);
        }
        return blockstate;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState state, Property<T> property, String value) {
        return property.m_6215_(value).map(p_219986_2_ -> (BlockState)state.m_61124_(property, p_219986_2_)).orElse(state);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.m_43725_().m_7731_(context.m_8083_(), state, 11);
    }

    @Nullable
    protected BlockState getStateForPlacement(BlockPlaceContext context, ItemStack torch) {
        BlockState blockstate = torch.m_41720_() == Items.f_42053_ ? Blocks.f_50140_.m_5573_(context) : Blocks.f_50082_.m_5573_(context);
        BlockState blockstate1 = null;
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate2;
            if (direction == Direction.UP) continue;
            BlockState blockState = direction == Direction.DOWN ? (torch.m_41720_() == Items.f_42053_ ? Blocks.f_50139_.m_5573_(context) : Blocks.f_50081_.m_5573_(context)) : (blockstate2 = blockstate);
            if (blockstate2 == null || !blockstate2.m_60710_((LevelReader)iworldreader, blockpos)) continue;
            blockstate1 = blockstate2;
            break;
        }
        return blockstate1 != null && iworldreader.m_45752_(blockstate1, blockpos, CollisionContext.m_82749_()) ? blockstate1 : null;
    }
}

