/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.behaviour;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import muramasa.antimatter.behaviour.IItemUse;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.behaviour.BehaviourUtil;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BehaviourLogStripping
implements IItemUse<IAntimatterTool> {
    public static final BehaviourLogStripping INSTANCE = new BehaviourLogStripping();
    private static final Object2ObjectOpenHashMap<BlockState, BlockState> STRIPPING_MAP = new Object2ObjectOpenHashMap();

    @Override
    public String getId() {
        return "log_stripping";
    }

    @Override
    public InteractionResult onItemUse(IAntimatterTool instance, UseOnContext c) {
        BlockState state = c.m_43725_().m_8055_(c.m_8083_());
        BlockState stripped = this.getToolModifiedState(state, c.m_43725_(), c.m_8083_(), c.m_43723_(), c.m_43722_(), "axe_strip");
        if (stripped != null) {
            if (state.m_61138_((Property)RotatedPillarBlock.f_55923_) && stripped.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                stripped = (BlockState)stripped.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)));
            }
            c.m_43725_().m_5594_(c.m_43723_(), c.m_8083_(), SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            c.m_43725_().m_46597_(c.m_8083_(), stripped);
            Utils.damageStack(c.m_43722_(), (LivingEntity)c.m_43723_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private BlockState getToolModifiedState(BlockState originalState, Level world, BlockPos pos, Player player, ItemStack stack, String action) {
        BlockState eventState = BehaviourUtil.onToolUse(originalState, world, pos, player, stack, action);
        return eventState != originalState ? eventState : (BlockState)STRIPPING_MAP.get((Object)originalState);
    }

    public static void addStrippedBlock(Block from, Block to) {
        BehaviourLogStripping.addStrippedState(from.m_49966_(), to.m_49966_());
    }

    public static void addStrippedState(BlockState from, BlockState to) {
        STRIPPING_MAP.put((Object)from, (Object)to);
    }

    static {
        new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).build().forEach(BehaviourLogStripping::addStrippedBlock);
    }
}

