/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.behaviour;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiFunction;
import java.util.function.Function;
import muramasa.antimatter.behaviour.IItemHighlight;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.AntimatterCapUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;

public class BehaviourExtendedHighlight
implements IItemHighlight<IAntimatterTool> {
    final float INDENTATION_SIDE = 0.25f;
    final double INTERACT_DISTANCE = 5.0;
    protected Function<Block, Boolean> validator;
    protected BiFunction<Direction, BlockEntity, Boolean> function;
    public static final BiFunction<Direction, BlockEntity, Boolean> COVER_FUNCTION = (dir, tile) -> {
        if (tile instanceof TileEntityBase) {
            TileEntityBase base = (TileEntityBase)((Object)tile);
            return AntimatterCapUtils.getCoverHandler(base, dir).map(t -> !t.get((Direction)dir).isEmpty()).orElse(false);
        }
        return false;
    };
    public static final BiFunction<Direction, BlockEntity, Boolean> PIPE_FUNCTION = (dir, tile) -> {
        if (tile instanceof TileEntityPipe) {
            return ((TileEntityPipe)tile).canConnect(dir.m_122411_());
        }
        if (tile instanceof TileEntityMachine) {
            Direction direction = ((TileEntityMachine)tile).getOutputFacing();
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6047_()) {
                direction = ((TileEntityMachine)tile).getFacing();
            }
            return direction != null && direction == dir;
        }
        if (tile instanceof HopperBlockEntity) {
            HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)tile;
            if (dir != Direction.UP) {
                return hopperBlockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61373_) == dir;
            }
        }
        return false;
    };

    public BehaviourExtendedHighlight(Function<Block, Boolean> validator, BiFunction<Direction, BlockEntity, Boolean> builder) {
        this.validator = validator;
        this.function = builder;
    }

    @Override
    public String getId() {
        return "extended_highlight";
    }

    @Override
    public InteractionResult onDrawHighlight(Player player, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        return RenderHelper.onDrawHighlight(player, levelRenderer, camera, target, partialTicks, poseStack, multiBufferSource, this.validator, this.function);
    }
}

