/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.behaviour;

import java.util.List;
import muramasa.antimatter.behaviour.IAddInformation;
import muramasa.antimatter.behaviour.IBlockDestroyed;
import muramasa.antimatter.behaviour.IItemRightClick;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BehaviourAOEBreak
implements IBlockDestroyed<IAntimatterTool>,
IItemRightClick<IAntimatterTool>,
IAddInformation<IAntimatterTool> {
    protected int column;
    protected int row;
    protected int depth;
    protected String tooltipKey;

    public BehaviourAOEBreak(int column, int row, int depth, String tooltipKey) {
        if (column == 0 && row == 0) {
            Utils.onInvalidData("BehaviourAOEBreak was set to break empty rows and columns!");
        }
        this.column = column;
        this.row = row;
        this.depth = depth;
        this.tooltipKey = tooltipKey;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getId() {
        return "aoe_break";
    }

    @Override
    public void onAddInformation(IAntimatterTool instance, ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = instance.getDataTag(stack);
        if (tag != null) {
            boolean enabled = tag.m_128471_("aoe");
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.behaviour.aoe_right_click", new Object[]{new TranslatableComponent("antimatter.behaviour." + this.tooltipKey)}));
            String suffix = enabled ? "enabled" : "disabled";
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.behaviour.aoe_" + suffix, new Object[]{new TranslatableComponent("antimatter.behaviour." + this.tooltipKey)}));
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> onRightClick(IAntimatterTool instance, Level level, Player player, InteractionHand usedHand) {
        CompoundTag tag;
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_() && !level.f_46443_ && (tag = instance.getDataTag(stack)) != null) {
            boolean enabled = tag.m_128471_("aoe");
            tag.m_128379_("aoe", !enabled);
            player.m_6352_((Component)new TextComponent("Mode set to " + !enabled), player.m_142081_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public boolean onBlockDestroyed(IAntimatterTool instance, ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        CompoundTag tag = instance.getDataTag(stack);
        if (tag == null || !tag.m_128471_("aoe")) {
            return true;
        }
        Player player = (Player)entity;
        for (BlockPos blockPos : Utils.getHarvestableBlocksToBreak(world, player, instance, stack, this.column, this.row, this.depth)) {
            if (!instance.hasEnoughDurability(stack, instance.getAntimatterToolType().getUseDurability(), instance.getAntimatterToolType().isPowered())) {
                return true;
            }
            if (Utils.breakBlock(world, player, stack, blockPos, instance.getAntimatterToolType().getUseDurability())) continue;
            break;
        }
        return true;
    }
}

