/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool.armor;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.tool.IAntimatterArmor;
import muramasa.antimatter.tool.ToolUtils;
import muramasa.antimatter.tool.armor.MaterialArmor;
import muramasa.antimatter.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class AntimatterArmorType
implements ISharedAntimatterObject {
    private final String domain;
    private final String id;
    private final List<Component> tooltip = new ObjectArrayList();
    private final boolean repairable;
    private final int durabilityFactor;
    private final int extraArmor;
    private final float extraToughness;
    private final float extraKnockback;
    private final CreativeModeTab itemGroup;
    private EquipmentSlot slot;
    private SoundEvent event;
    int overlayLayers;
    @Nullable
    private IMaterialTag materialRequirement;

    public AntimatterArmorType(String domain, String id, int durabilityFactor, int extraArmor, float extraToughness, float extraKnockback, EquipmentSlot slot) {
        this.domain = domain;
        this.id = id;
        this.repairable = true;
        this.durabilityFactor = durabilityFactor;
        this.extraArmor = extraArmor;
        this.extraToughness = extraToughness;
        this.extraKnockback = extraKnockback;
        this.itemGroup = Ref.TAB_TOOLS;
        this.slot = slot;
        this.event = SoundEvents.f_11677_;
        this.overlayLayers = 0;
        AntimatterAPI.register(AntimatterArmorType.class, this);
    }

    public List<IAntimatterArmor> instantiateTools() {
        ArrayList<IAntimatterArmor> armors = new ArrayList<IAntimatterArmor>();
        MaterialTags.ARMOR.all().forEach(m -> armors.add(new MaterialArmor("antimatter_shared", this, (Material)m, this.slot, this.prepareInstantiation("antimatter_shared"))));
        return armors;
    }

    public List<IAntimatterArmor> instantiateTools(String domain, Supplier<Item.Properties> properties) {
        ArrayList<IAntimatterArmor> armors = new ArrayList<IAntimatterArmor>();
        MaterialTags.ARMOR.all().forEach(m -> armors.add(new MaterialArmor(domain, this, (Material)m, this.slot, (Item.Properties)properties.get())));
        return armors;
    }

    private Item.Properties prepareInstantiation(String domain) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("An AntimatterArmorType was instantiated with an empty domain name!");
        }
        return ToolUtils.getToolProperties(this.itemGroup, this.repairable);
    }

    public AntimatterArmorType setOverlayLayers(int overlayLayers) {
        this.overlayLayers = overlayLayers;
        return this;
    }

    public AntimatterArmorType setEvent(SoundEvent event) {
        this.event = event;
        return this;
    }

    public AntimatterArmorType setArmorSlot(EquipmentSlot slot) {
        this.slot = slot;
        return this;
    }

    public AntimatterArmorType setToolTip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public AntimatterArmorType setPrimaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterArmorType was set to have no primary material requirement even when it was explicitly called!");
        }
        this.materialRequirement = tag;
        return this;
    }

    public ItemStack getToolStack(Material primary) {
        return Objects.requireNonNull(AntimatterAPI.get(IAntimatterArmor.class, primary.getId() + "_" + this.id)).asItemStack();
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean isRepairable() {
        return this.repairable;
    }

    public int getOverlayLayers() {
        return this.overlayLayers;
    }

    public int getDurabilityFactor() {
        return this.durabilityFactor;
    }

    public int getExtraArmor() {
        return this.extraArmor;
    }

    public float getExtraToughness() {
        return this.extraToughness;
    }

    public float getExtraKnockback() {
        return this.extraKnockback;
    }

    public CreativeModeTab getItemGroup() {
        return this.itemGroup;
    }

    public EquipmentSlot getSlot() {
        return this.slot;
    }

    public SoundEvent getEvent() {
        return this.event;
    }
}

