/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.energy.ItemEnergyHandler;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.item.IContainerItem;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.tool.AntimatterItemTier;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.ToolUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import tesseract.TesseractCapUtils;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MaterialTool
extends DiggerItem
implements IAntimatterTool,
IContainerItem {
    protected final String domain;
    protected final AntimatterToolType type;
    protected final int energyTier;
    protected final long maxEnergy;

    public MaterialTool(String domain, AntimatterToolType type, Item.Properties properties) {
        super(type.getBaseAttackDamage(), type.getBaseAttackSpeed(), (Tier)AntimatterItemTier.NULL, type.getToolType(), properties);
        this.domain = domain;
        this.type = type;
        this.energyTier = -1;
        this.maxEnergy = -1L;
        AntimatterAPI.register(IAntimatterTool.class, this);
    }

    public MaterialTool(String domain, AntimatterToolType type, Item.Properties properties, int energyTier) {
        super(type.getBaseAttackDamage(), type.getBaseAttackSpeed(), (Tier)AntimatterItemTier.NULL, type.getToolType(), properties);
        this.domain = domain;
        this.type = type;
        this.energyTier = energyTier;
        this.maxEnergy = type.getBaseMaxEnergy() * (long)energyTier;
        AntimatterAPI.register(IAntimatterTool.class, this);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.type.isPowered() ? String.join((CharSequence)"_", this.type.getId(), Ref.VN[this.energyTier].toLowerCase(Locale.ENGLISH)) : this.type.getId();
    }

    @Override
    @Nonnull
    public AntimatterToolType getAntimatterToolType() {
        return this.type;
    }

    public int getEnergyTier() {
        return this.energyTier;
    }

    @Override
    @Nonnull
    public ItemStack asItemStack(@Nonnull Material primary, @Nonnull Material secondary) {
        return this.resolveStack(primary, secondary, 0L, this.maxEnergy);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        this.onGenericFillItemGroup(group, list, this.maxEnergy);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return Utils.doesStackHaveToolTypes(stack, AntimatterDefaultTools.WRENCH, AntimatterDefaultTools.ELECTRIC_WRENCH, AntimatterDefaultTools.SCREWDRIVER, AntimatterDefaultTools.ELECTRIC_SCREWDRIVER, AntimatterDefaultTools.CROWBAR, AntimatterDefaultTools.WIRE_CUTTER);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        AntimatterToolType type = this.getAntimatterToolType();
        if (type.getEffectiveMaterials().contains(state.m_60767_())) {
            return true;
        }
        if (type.getEffectiveBlocks().contains(state.m_60734_())) {
            return true;
        }
        return state.m_204336_(this.getAntimatterToolType().getToolType()) && ToolUtils.isCorrectTierForDrops(this.getTier(stack), state);
    }

    public boolean isSuitableFor(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state);
    }

    public void m_5929_(Level p_41428_, LivingEntity p_41429_, ItemStack p_41430_, int p_41431_) {
        super.m_5929_(p_41428_, p_41429_, p_41430_, p_41431_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.type.getUseAction();
    }

    public int m_8105_(ItemStack stack) {
        return this.type.getUseAction() == UseAnim.NONE ? super.m_8105_(stack) : 72000;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        if (this.getId().equals("branch_cutter")) {
            return Math.round((float)this.getTier(stack).m_6609_() / 4.0f);
        }
        return this.getTier(stack).m_6609_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.onGenericHitEntity(stack, target, attacker, 0.75f, 0.75f);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) ? this.getTier(stack).m_6624_() : 1.0f;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        return this.onGenericBlockDestroyed(stack, world, state, pos, entity);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onGenericItemUse(ctx);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        InteractionResultHolder result = this.onGenericRightclick(level, player, usedHand);
        if (result.m_19089_().m_146666_()) {
            return result;
        }
        return super.m_7203_(level, player, usedHand);
    }

    public void handleRenderHighlight(Player entity, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        this.onGenericHighlight(entity, levelRenderer, camera, target, partialTicks, poseStack, multiBufferSource);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return this.type.getBlockBreakability();
    }

    @Override
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.type.getActualTags().contains(BlockTags.f_144280_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotType, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slotType == EquipmentSlot.MAINHAND) {
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(this.type.getBaseAttackDamage() + this.getTier(stack).m_6631_()), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.type.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, EquipmentSlot slotType) {
        return this.getAttributeModifiers(slotType, stack);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (!this.type.isPowered()) {
            return amount;
        }
        if (entity instanceof Player && ((Player)entity).m_7500_()) {
            return 0;
        }
        return this.damage(stack, amount);
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public int getEnchantability(ItemStack stack) {
        return this.getItemEnchantability(stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return !this.type.isPowered() && this.getTier(toRepair).m_6282_().test(repair);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (this.type.getActualTags().contains(BlockTags.f_144280_) && enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return this.type.isPowered() ? enchantment != Enchantments.f_44986_ : enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return this.type.hasContainer();
    }

    @Override
    public ItemStack getContainerItem(ItemStack oldStack) {
        return this.getGenericContainerItem(oldStack);
    }

    public int m_142159_(ItemStack stack) {
        if (this.type.isPowered()) {
            return this.getCurrentEnergy(stack) > 0L ? 49151 : super.m_142159_(stack);
        }
        return super.m_142159_(stack);
    }

    public int m_142158_(ItemStack stack) {
        if (!this.type.isPowered()) {
            return super.m_142158_(stack);
        }
        long currentEnergy = this.getCurrentEnergy(stack);
        if (currentEnergy > 0L) {
            double maxAmount = this.getMaxEnergy(stack);
            return (int)(13.0 * ((double)currentEnergy / maxAmount));
        }
        return super.m_142158_(stack);
    }

    public boolean m_142522_(ItemStack stack) {
        if (this.type.isPowered()) {
            return true;
        }
        return super.m_142522_(stack);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, this.maxEnergy, 8 * (int)Math.pow(4.0, this.energyTier), 8 * (int)Math.pow(4.0, this.energyTier), 1, 1);
    }

    private Optional<ItemEnergyHandler> getCastedHandler(ItemStack stack) {
        return TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack).map(e -> (ItemEnergyHandler)e);
    }
}

