/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.energy.ItemEnergyHandler;
import muramasa.antimatter.item.IContainerItem;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.tool.AntimatterItemTier;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.Utils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MaterialSword
extends SwordItem
implements IAntimatterTool,
IContainerItem {
    protected String domain;
    protected AntimatterToolType type;
    protected int energyTier;
    protected long maxEnergy;

    public MaterialSword(String domain, AntimatterToolType type, Item.Properties properties) {
        super((Tier)AntimatterItemTier.NULL, 0, type.getBaseAttackSpeed(), properties);
        this.domain = domain;
        this.type = type;
        this.energyTier = -1;
        this.maxEnergy = -1L;
        AntimatterAPI.register(IAntimatterTool.class, this);
    }

    public MaterialSword(String domain, AntimatterToolType type, Item.Properties properties, int energyTier) {
        super((Tier)AntimatterItemTier.NULL, (int)type.getBaseAttackDamage(), type.getBaseAttackSpeed(), properties);
        this.domain = domain;
        this.type = type;
        this.energyTier = energyTier;
        this.maxEnergy = type.getBaseMaxEnergy() * (long)energyTier;
        AntimatterAPI.register(IAntimatterTool.class, this);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.type.isPowered() ? String.join((CharSequence)"_", this.type.getId(), Ref.VN[this.energyTier].toLowerCase(Locale.ENGLISH)) : this.type.getId();
    }

    @Override
    @Nonnull
    public AntimatterToolType getAntimatterToolType() {
        return this.type;
    }

    public int getEnergyTier() {
        return this.energyTier;
    }

    @Override
    @Nonnull
    public ItemStack asItemStack(@Nonnull Material primary, @Nonnull Material secondary) {
        return this.resolveStack(primary, secondary, 0L, this.maxEnergy);
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        this.onGenericFillItemGroup(group, list, this.maxEnergy);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        this.onGenericAddInformation(stack, tooltip, flag);
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return this.type.getUseAction();
    }

    public int m_8105_(ItemStack stack) {
        return this.type.getUseAction() == UseAnim.NONE ? super.m_8105_(stack) : 72000;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        return this.getTier(stack).m_6609_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.onGenericHitEntity(stack, target, attacker, 0.75f, 0.75f);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_60734_() == Blocks.f_50033_) {
            return 15.0f;
        }
        return Utils.isToolEffective(this, stack, state) ? this.getTier(stack).m_6624_() : 1.0f;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        return this.onGenericBlockDestroyed(stack, world, state, pos, entity);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return this.onGenericItemUse(ctx);
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player player) {
        return this.type.getBlockBreakability();
    }

    @Override
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.type.getActualTags().contains(BlockTags.f_144280_);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slotType, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slotType == EquipmentSlot.MAINHAND) {
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.type.getBaseAttackDamage() + this.getTier(stack).m_6631_()), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.type.getBaseAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack stack, EquipmentSlot slotType) {
        return this.getAttributeModifiers(slotType, stack);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return entity instanceof Player && ((Player)entity).m_7500_() ? 0 : this.damage(stack, amount);
    }

    @Override
    public int getItemEnchantability(ItemStack stack) {
        return this.getTier(stack).m_6601_();
    }

    public int getEnchantability(ItemStack stack) {
        return this.getItemEnchantability(stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return !this.type.isPowered() && this.getTier(toRepair).m_6282_().test(repair);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.type.isPowered() ? enchantment != Enchantments.f_44986_ : enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @Override
    public boolean hasContainerItem(ItemStack stack) {
        return this.type.hasContainer();
    }

    @Override
    public ItemStack getContainerItem(ItemStack oldStack) {
        return this.getGenericContainerItem(oldStack);
    }

    public IEnergyHandlerItem createEnergyHandler(TesseractItemContext context) {
        return new ItemEnergyHandler(context, this.maxEnergy, 8 * (int)Math.pow(4.0, this.energyTier), 8 * (int)Math.pow(4.0, this.energyTier), 1, 1);
    }
}

