/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.behaviour.IAddInformation;
import muramasa.antimatter.behaviour.IBehaviour;
import muramasa.antimatter.behaviour.IBlockDestroyed;
import muramasa.antimatter.behaviour.IItemHighlight;
import muramasa.antimatter.behaviour.IItemRightClick;
import muramasa.antimatter.behaviour.IItemUse;
import muramasa.antimatter.capability.energy.ItemEnergyHandler;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tool.AntimatterItemTier;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.IAbstractToolMethods;
import muramasa.antimatter.util.Utils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import tesseract.TesseractCapUtils;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IEnergyItem;

public interface IAntimatterTool
extends IAntimatterObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IAbstractToolMethods,
IEnergyItem {
    public AntimatterToolType getAntimatterToolType();

    default public Material getPrimaryMaterial(ItemStack stack) {
        return Material.get(this.getDataTag(stack).m_128461_("m"));
    }

    default public Material getSecondaryMaterial(ItemStack stack) {
        return Material.get(this.getDataTag(stack).m_128461_("sm"));
    }

    default public DyeColor getDyeColor(ItemStack stack) {
        CompoundTag data = this.getDataTag(stack);
        if (data.m_128441_("sc")) {
            Optional<DyeColor> color = Arrays.stream(DyeColor.values()).filter(t -> t.m_41069_().f_76396_ == data.m_128451_("sc")).findFirst();
            return color.orElse(DyeColor.WHITE);
        }
        return null;
    }

    default public Material[] getMaterials(ItemStack stack) {
        CompoundTag tag = this.getDataTag(stack);
        return new Material[]{Material.get(tag.m_128461_("m")), Material.get(tag.m_128461_("sm"))};
    }

    default public Item getItem() {
        return (Item)this;
    }

    default public Set<TagKey<Block>> getActualTags() {
        return this.getAntimatterToolType().getActualTags();
    }

    default public int getSubColour(ItemStack stack) {
        return this.getDyeColor(stack) == null ? 0 : this.getDyeColor((ItemStack)stack).m_41069_().f_76396_;
    }

    default public long getCurrentEnergy(ItemStack stack) {
        return this.getEnergyTag(stack).m_128454_("e");
    }

    default public long getMaxEnergy(ItemStack stack) {
        return this.getEnergyTag(stack).m_128454_("me");
    }

    default public boolean canCreate(TesseractItemContext context) {
        return this.getAntimatterToolType().isPowered();
    }

    public ItemStack asItemStack(Material var1, Material var2);

    default public CompoundTag getEnergyTag(ItemStack stack) {
        CompoundTag dataTag = stack.m_41737_("ied");
        return dataTag != null ? dataTag : this.validateEnergyTag(stack, 0L, 10000L);
    }

    default public CompoundTag getDataTag(ItemStack stack) {
        CompoundTag dataTag = stack.m_41737_("td");
        return dataTag != null ? dataTag : this.validateTag(stack, Material.NULL, Material.NULL, 0L, 10000L);
    }

    default public Tier getTier(ItemStack stack) {
        CompoundTag dataTag = this.getDataTag(stack);
        Optional<AntimatterItemTier> tier = AntimatterItemTier.get(dataTag.m_128451_("t"));
        return tier.orElseGet(() -> this.resolveTierTag(dataTag));
    }

    default public ItemStack resolveStack(Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        Item item = (Item)this;
        ItemStack stack = new ItemStack((ItemLike)item);
        this.validateTag(stack, primary, secondary, startingEnergy, maxEnergy);
        if (!primary.has(MaterialTags.TOOLS) || !secondary.has(MaterialTags.HANDLE) && secondary != Material.NULL) {
            return stack;
        }
        ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.TOOLS.get(primary).toolEnchantment();
        ImmutableMap<Enchantment, Integer> handleEnchants = MaterialTags.HANDLE.get(secondary).toolEnchantment();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
        }
        if (!handleEnchants.isEmpty()) {
            handleEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack) && !mainEnchants.containsKey(e.getKey())).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
        }
        return stack;
    }

    default public CompoundTag validateTag(ItemStack stack, Material primary, Material secondary, long startingEnergy, long maxEnergy) {
        CompoundTag dataTag = stack.m_41698_("td");
        dataTag.m_128359_("m", primary.getId());
        dataTag.m_128359_("sm", secondary.getId());
        if (!this.getAntimatterToolType().isPowered()) {
            return dataTag;
        }
        this.validateEnergyTag(stack, startingEnergy, maxEnergy);
        return dataTag;
    }

    default public CompoundTag validateEnergyTag(ItemStack stack, long startingEnergy, long maxEnergy) {
        IEnergyHandlerItem h = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack).orElse(null);
        if (h != null) {
            h.setEnergy(startingEnergy);
            h.setCapacity(maxEnergy);
            stack.m_41751_(h.getContainer().getTag());
        }
        return stack.m_41698_("ied");
    }

    default public AntimatterItemTier resolveTierTag(CompoundTag dataTag) {
        AntimatterItemTier tier = AntimatterItemTier.getOrCreate(dataTag.m_128461_("m"), dataTag.m_128461_("sm"));
        dataTag.m_128405_("t", tier.hashCode());
        return tier;
    }

    default public void onGenericFillItemGroup(CreativeModeTab group, NonNullList<ItemStack> list, long maxEnergy) {
        if (group != Ref.TAB_TOOLS) {
            return;
        }
        if (this.getAntimatterToolType().isPowered()) {
            ItemStack stack = this.asItemStack(Material.NULL, Material.NULL);
            IEnergyHandlerItem h = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack).orElse(null);
            if (h != null) {
                list.add((Object)stack.m_41777_());
                h.setCapacity(maxEnergy);
                h.setEnergy(maxEnergy);
                stack.m_41751_(h.getContainer().getTag());
                list.add((Object)stack);
            }
        } else {
            list.add((Object)this.asItemStack(Material.NULL, Material.NULL));
        }
    }

    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        DyeColor color;
        Material primary = this.getPrimaryMaterial(stack);
        Material secondary = this.getSecondaryMaterial(stack);
        tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.material_primary", new Object[]{primary.getDisplayName().getString()}));
        if (secondary != Material.NULL) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.material_secondary", new Object[]{secondary.getDisplayName().getString()}));
        }
        if ((color = this.getDyeColor(stack)) != null) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.dye_color", new Object[]{color.m_41065_()}));
        }
        if (flag.m_7050_() && this.getAntimatterToolType().isPowered()) {
            tooltip.add((Component)new TranslatableComponent("antimatter.tooltip.energy").m_130946_(": " + this.getCurrentEnergy(stack) + " / " + this.getMaxEnergy(stack)));
        }
        if (this.getAntimatterToolType().getTooltip().size() != 0) {
            tooltip.addAll(this.getAntimatterToolType().getTooltip());
        }
        for (Map.Entry e : this.getAntimatterToolType().getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IAddInformation)) continue;
            IAddInformation addInformation = (IAddInformation)b;
            addInformation.onAddInformation(this, stack, tooltip, flag);
        }
    }

    default public boolean onGenericHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker, float volume, float pitch) {
        if (this.getAntimatterToolType().getUseSound() != null) {
            target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getAntimatterToolType().getUseSound(), SoundSource.HOSTILE, volume, pitch);
        }
        Utils.damageStack(this.getAntimatterToolType().getAttackDurability(), stack, attacker);
        return true;
    }

    default public boolean onGenericBlockDestroyed(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.getAntimatterToolType().getUseSound() != null) {
                player.m_6330_(this.getAntimatterToolType().getUseSound(), SoundSource.BLOCKS, 0.84f, 0.75f);
            }
            boolean isToolEffective = Utils.isToolEffective(this.getAntimatterToolType(), this.getActualTags(), state);
            if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
                Utils.damageStack(isToolEffective ? this.getAntimatterToolType().getUseDurability() : this.getAntimatterToolType().getUseDurability() + 1, stack, entity);
            }
        }
        boolean returnValue = true;
        for (Map.Entry e : this.getAntimatterToolType().getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IBlockDestroyed)) continue;
            returnValue = ((IBlockDestroyed)b).onBlockDestroyed(this, stack, world, state, pos, entity);
        }
        return returnValue;
    }

    default public InteractionResult onGenericItemUse(UseOnContext ctx) {
        InteractionResult result = InteractionResult.PASS;
        for (Map.Entry e : this.getAntimatterToolType().getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemUse)) continue;
            IItemUse itemUse = (IItemUse)b;
            InteractionResult r = itemUse.onItemUse(this, ctx);
            if (result == InteractionResult.SUCCESS) continue;
            result = r;
        }
        return result;
    }

    default public InteractionResultHolder<ItemStack> onGenericRightclick(Level level, Player player, InteractionHand usedHand) {
        for (Map.Entry e : this.getAntimatterToolType().getBehaviours().entrySet()) {
            IItemRightClick rightClick;
            InteractionResultHolder<ItemStack> r;
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemRightClick) || !(r = (rightClick = (IItemRightClick)b).onRightClick(this, level, player, usedHand)).m_19089_().m_146666_()) continue;
            return r;
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(usedHand));
    }

    default public InteractionResult onGenericHighlight(Player player, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        InteractionResult result = InteractionResult.PASS;
        for (Map.Entry e : this.getAntimatterToolType().getBehaviours().entrySet()) {
            IBehaviour b = (IBehaviour)e.getValue();
            if (!(b instanceof IItemHighlight)) continue;
            InteractionResult type = ((IItemHighlight)b).onDrawHighlight(player, levelRenderer, camera, target, partialTicks, poseStack, multiBufferSource);
            if (type != InteractionResult.SUCCESS) {
                result = type;
                continue;
            }
            return InteractionResult.FAIL;
        }
        return result;
    }

    default public ItemStack getGenericContainerItem(ItemStack oldStack) {
        ItemStack stack = oldStack.m_41777_();
        int amount = this.damage(stack, this.getAntimatterToolType().getCraftingDurability());
        if (!this.getAntimatterToolType().isPowered()) {
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
            int j = 0;
            for (int k = 0; level > 0 && k < amount; ++k) {
                if (!DigDurabilityEnchantment.m_44655_((ItemStack)stack, (int)level, (Random)Ref.RNG)) continue;
                ++j;
            }
            amount -= j;
        }
        boolean empty = false;
        if (amount > 0) {
            int l = stack.m_41773_() + amount;
            stack.m_41721_(l);
            boolean bl = empty = l >= stack.m_41776_();
        }
        if (empty) {
            if (!this.getAntimatterToolType().getBrokenItems().containsKey((Object)this.getId())) {
                return ItemStack.f_41583_;
            }
            ItemStack item = (ItemStack)((Function)this.getAntimatterToolType().getBrokenItems().get((Object)this.getId())).apply(oldStack);
            return item;
        }
        return stack;
    }

    default public int damage(ItemStack stack, int amount) {
        if (!this.getAntimatterToolType().isPowered()) {
            return amount;
        }
        IEnergyHandlerItem h = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack).orElse(null);
        if (!(h instanceof ItemEnergyHandler)) {
            return amount;
        }
        long currentEnergy = h.getEnergy();
        int multipliedDamage = amount * 100;
        if (Ref.RNG.nextInt(20) == 0) {
            return amount;
        }
        if (currentEnergy >= (long)multipliedDamage) {
            Utils.extractEnergy((IEnergyHandler)h, multipliedDamage);
            stack.m_41751_(h.getContainer().getTag());
            return 0;
        }
        int leftOver = (int)((long)multipliedDamage - currentEnergy);
        Utils.extractEnergy((IEnergyHandler)h, currentEnergy);
        stack.m_41751_(h.getContainer().getTag());
        return Math.max(1, leftOver / 100);
    }

    default public boolean hasEnoughDurability(ItemStack stack, int damage, boolean energy) {
        if (energy && this.getCurrentEnergy(stack) >= (long)(damage * 100)) {
            return true;
        }
        return stack.m_41773_() >= damage;
    }

    default public void onItemBreak(ItemStack stack, Player entity) {
        String name = this.getId();
        AntimatterToolType type = this.getAntimatterToolType();
        if (!type.getBrokenItems().containsKey((Object)name)) {
            return;
        }
        ItemStack item = (ItemStack)((Function)type.getBrokenItems().get((Object)name)).apply(stack);
        if (!item.m_41619_() && !entity.m_36356_(item)) {
            entity.m_36176_(item, true);
        }
    }

    @Override
    default public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.getPrimaryMaterial(stack).getRGB() : (this.getSubColour(stack) == 0 ? this.getSecondaryMaterial(stack).getRGB() : this.getSubColour(stack));
    }

    @Override
    default public Texture[] getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        int layers = this.getAntimatterToolType().getOverlayLayers();
        textures.add(new Texture(this.getDomain(), "item/tool/".concat(this.getAntimatterToolType().getId())));
        if (layers == 1) {
            textures.add(new Texture(this.getDomain(), "item/tool/overlay/".concat(this.getAntimatterToolType().getId())));
        }
        if (layers > 1) {
            for (int i = 1; i <= layers; ++i) {
                textures.add(new Texture(this.getDomain(), String.join((CharSequence)"", "item/tool/overlay/", this.getAntimatterToolType().getId(), "_", Integer.toString(i))));
            }
        }
        return textures.toArray(new Texture[textures.size()]);
    }

    @Override
    default public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures());
    }

    public boolean doesSneakBypassUse(ItemStack var1, LevelReader var2, BlockPos var3, Player var4);

    public boolean canDisableShield(ItemStack var1, ItemStack var2, LivingEntity var3, LivingEntity var4);

    public int getItemEnchantability(ItemStack var1);
}

