/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tool.IAbstractToolMethods;
import muramasa.antimatter.tool.armor.AntimatterArmorType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public interface IAntimatterArmor
extends ISharedAntimatterObject,
IColorHandler,
ITextureProvider,
IModelProvider,
IAbstractToolMethods {
    public AntimatterArmorType getAntimatterArmorType();

    public Material getMat();

    public ItemStack asItemStack();

    default public Item getItem() {
        return (Item)this;
    }

    default public ItemStack resolveStack() {
        Item item = (Item)this;
        ItemStack stack = new ItemStack((ItemLike)item);
        ImmutableMap<Enchantment, Integer> mainEnchants = MaterialTags.ARMOR.get(this.getMat()).toolEnchantment();
        if (!mainEnchants.isEmpty()) {
            mainEnchants.entrySet().stream().filter(e -> ((Enchantment)e.getKey()).m_6081_(stack)).forEach(e -> stack.m_41663_((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue()));
            return stack;
        }
        return stack;
    }

    default public void onGenericAddInformation(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        if (this.getAntimatterArmorType().getTooltip().size() != 0) {
            tooltip.addAll(this.getAntimatterArmorType().getTooltip());
        }
    }

    @Override
    default public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 && this.getMat() != null ? this.getMat().getRGB() : -1;
    }

    @Override
    default public Texture[] getTextures() {
        ObjectArrayList textures = new ObjectArrayList();
        int layers = this.getAntimatterArmorType().getOverlayLayers();
        textures.add(new Texture("antimatter", "item/tool/".concat(this.getAntimatterArmorType().getId())));
        if (layers == 1) {
            textures.add(new Texture("antimatter", "item/tool/overlay/".concat(this.getAntimatterArmorType().getId())));
        }
        if (layers > 1) {
            for (int i = 1; i <= layers; ++i) {
                textures.add(new Texture("antimatter", String.join((CharSequence)"", "item/tool/overlay/", this.getAntimatterArmorType().getId(), "_", Integer.toString(i))));
            }
        }
        return textures.toArray(new Texture[textures.size()]);
    }

    @Override
    default public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        if (this.getAntimatterArmorType().getSlot() == EquipmentSlot.HEAD) {
            String id = this.getId();
            AntimatterItemModelBuilder builder = (AntimatterItemModelBuilder)prov.getBuilder(id + "_probe");
            builder.parent(new ResourceLocation("minecraft", "item/handheld"));
            Texture[] textures = this.getTextures();
            for (int i = 0; i < textures.length + 1; ++i) {
                if (i == textures.length) {
                    builder.texture("layer" + i, new Texture("antimatter", "item/tool/overlay/".concat(this.getAntimatterArmorType().getId()).concat("_probe")));
                    continue;
                }
                builder.texture("layer" + i, textures[i]);
            }
            prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures()).override().predicate(new ResourceLocation("antimatter", "probe"), 1.0f).model(new ResourceLocation("antimatter_shared", "item/" + id + "_probe")).end();
            return;
        }
        prov.tex(item, "minecraft:item/handheld", (ResourceLocation[])this.getTextures());
    }
}

