/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.behaviour.IBehaviour;
import muramasa.antimatter.material.IMaterialTag;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.MaterialSword;
import muramasa.antimatter.tool.MaterialTool;
import muramasa.antimatter.tool.ToolUtils;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class AntimatterToolType
implements ISharedAntimatterObject {
    private final String domain;
    private final String id;
    private TagKey<Block> TOOL_TYPE;
    private final Set<TagKey<Block>> TOOL_TYPES = new ObjectOpenHashSet();
    private final Set<Block> EFFECTIVE_BLOCKS = new ObjectOpenHashSet();
    private final Set<net.minecraft.world.level.material.Material> EFFECTIVE_MATERIALS = new ObjectOpenHashSet();
    private final Object2ObjectMap<String, IBehaviour<IAntimatterTool>> behaviours = new Object2ObjectOpenHashMap();
    private ImmutableMap<String, Function<ItemStack, ItemStack>> brokenItems = ImmutableMap.of();
    private final List<Component> tooltip = new ObjectArrayList();
    private boolean powered;
    private boolean repairable;
    private boolean blockBreakability;
    private boolean hasContainer;
    private long baseMaxEnergy;
    private int[] energyTiers;
    private final int useDurability;
    private final int attackDurability;
    private final int craftingDurability;
    private int baseQuality;
    private int overlayLayers;
    private final float baseAttackDamage;
    private final float baseAttackSpeed;
    private CreativeModeTab itemGroup;
    protected TagKey<Item> tag;
    protected TagKey<Item> forgeTag;
    private UseAnim useAction;
    private Class<? extends IAntimatterTool> toolClass;
    @Nullable
    private SoundEvent useSound;
    @Nullable
    private IMaterialTag primaryMaterialRequirement;
    @Nullable
    private IMaterialTag secondaryMaterialRequirement;

    public AntimatterToolType(String domain, String id, int useDurability, int attackDurability, int craftingDurability, float baseAttackDamage, float baseAttackSpeed, boolean vanillaType) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("AntimatterToolType registered with no domain name!");
        }
        this.domain = domain;
        if (id.isEmpty()) {
            Utils.onInvalidData("AntimatterToolType registered with an empty ID!");
        }
        this.id = id;
        if (useDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative use durability value!");
        }
        if (attackDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative attack durability value!");
        }
        if (craftingDurability < 0) {
            Utils.onInvalidData(id + " cannot have a negative crafting durability value!");
        }
        this.useSound = null;
        this.repairable = true;
        this.blockBreakability = true;
        this.hasContainer = true;
        this.baseQuality = 0;
        this.useDurability = useDurability;
        this.attackDurability = attackDurability;
        this.craftingDurability = craftingDurability;
        this.baseAttackDamage = baseAttackDamage;
        this.baseAttackSpeed = baseAttackSpeed;
        this.overlayLayers = 1;
        this.itemGroup = Ref.TAB_TOOLS;
        this.tag = TagUtils.getItemTag(new ResourceLocation("antimatter", id));
        this.forgeTag = TagUtils.getForgelikeItemTag("tools/".concat(id));
        this.useAction = UseAnim.NONE;
        this.toolClass = MaterialTool.class;
        this.TOOL_TYPE = vanillaType ? TagUtils.getBlockTag(new ResourceLocation("minecraft", "mineable/".concat(id))) : TagUtils.getBlockTag(new ResourceLocation("antimatter", "mineable/".concat(id)));
        this.TOOL_TYPES.add(this.TOOL_TYPE);
        this.setBrokenItems((ImmutableMap<String, Function<ItemStack, ItemStack>>)ImmutableMap.of((Object)id, i -> ItemStack.f_41583_));
        AntimatterAPI.register(AntimatterToolType.class, this);
    }

    public AntimatterToolType(String domain, String id, AntimatterToolType inheritType) {
        this(domain, id, inheritType.useDurability, inheritType.attackDurability, inheritType.craftingDurability, inheritType.baseAttackDamage, inheritType.baseAttackSpeed, false);
    }

    public IAntimatterTool instantiateTools(String domain, Object ... objects) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("An AntimatterToolType was instantiated with an empty domain name!");
        }
        if (objects.length == 0) {
            Utils.onInvalidData("An AntimatterToolType was instantiated with an empty arguments list!");
        }
        if (this.toolClass.equals(MaterialTool.class) || this.toolClass.equals(MaterialSword.class)) {
            Utils.onInvalidData("Please use the correct instantiation method in AntimatterToolType to return the correct instance!");
        }
        try {
            return (IAntimatterTool)ConstructorUtils.invokeConstructor(this.toolClass, (Object[])new Object[]{domain, objects});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<IAntimatterTool> instantiatePoweredTools(String domain) {
        ObjectArrayList poweredTools = new ObjectArrayList();
        Item.Properties properties = this.prepareInstantiation(domain);
        boolean isSword = this.toolClass == MaterialSword.class;
        for (int energyTier : this.energyTiers) {
            if (isSword) {
                poweredTools.add(new MaterialSword(domain, this, properties, energyTier));
                continue;
            }
            poweredTools.add(new MaterialTool(domain, this, properties, energyTier));
        }
        return poweredTools;
    }

    public List<IAntimatterTool> instantiatePoweredTools(String domain, Supplier<Item.Properties> properties) {
        ObjectArrayList poweredTools = new ObjectArrayList();
        boolean isSword = this.toolClass == MaterialSword.class;
        for (int energyTier : this.energyTiers) {
            if (isSword) {
                poweredTools.add(new MaterialSword(domain, this, properties.get(), energyTier));
                continue;
            }
            poweredTools.add(new MaterialTool(domain, this, properties.get(), energyTier));
        }
        return poweredTools;
    }

    public IAntimatterTool instantiateTools(String domain) {
        if (this.toolClass == MaterialSword.class) {
            return new MaterialSword(domain, this, this.prepareInstantiation(domain));
        }
        return new MaterialTool(domain, this, this.prepareInstantiation(domain));
    }

    public IAntimatterTool instantiateTools(String domain, Supplier<Item.Properties> properties) {
        if (this.toolClass == MaterialSword.class) {
            return new MaterialSword(domain, this, properties.get());
        }
        return new MaterialTool(domain, this, properties.get());
    }

    protected Item.Properties prepareInstantiation(String domain) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("An AntimatterToolType was instantiated with an empty domain name!");
        }
        return ToolUtils.getToolProperties(this.itemGroup, this.repairable);
    }

    public AntimatterToolType setToolTip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public AntimatterToolType setBrokenItems(ImmutableMap<String, Function<ItemStack, ItemStack>> map) {
        this.brokenItems = map;
        return this;
    }

    public AntimatterToolType setTag(AntimatterToolType tag) {
        this.tag = tag.getTag();
        this.forgeTag = tag.getForgeTag();
        return this;
    }

    public AntimatterToolType setType(AntimatterToolType tag) {
        this.TOOL_TYPES.remove(this.TOOL_TYPE);
        this.TOOL_TYPE = tag.getToolType();
        this.TOOL_TYPES.add(this.TOOL_TYPE);
        return this;
    }

    public AntimatterToolType setTag(ResourceLocation loc) {
        this.tag = TagUtils.getItemTag(loc);
        this.forgeTag = TagUtils.getForgelikeItemTag("tools/" + loc.m_135815_());
        return this;
    }

    public AntimatterToolType setPowered(long baseMaxEnergy, int ... energyTiers) {
        this.powered = true;
        this.baseMaxEnergy = baseMaxEnergy;
        this.energyTiers = energyTiers;
        return this;
    }

    public AntimatterToolType setHasContainer(boolean container) {
        this.hasContainer = container;
        return this;
    }

    public AntimatterToolType addTags(String ... types) {
        if (types.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have no additional tool types even when it was explicitly called!");
        }
        Arrays.stream(types).map(t -> TagUtils.getForgelikeBlockTag(t)).forEach(t -> this.TOOL_TYPES.add((TagKey<Block>)t));
        return this;
    }

    public AntimatterToolType addEffectiveBlocks(Block ... blocks) {
        if (blocks.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have no effective blocks even when it was explicitly called!");
        }
        this.EFFECTIVE_BLOCKS.addAll(Arrays.asList(blocks));
        return this;
    }

    public AntimatterToolType addEffectiveMaterials(net.minecraft.world.level.material.Material ... materials) {
        if (materials.length == 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have no effective materials even when it was explicitly called!");
        }
        this.EFFECTIVE_MATERIALS.addAll(Arrays.asList(materials));
        return this;
    }

    public AntimatterToolType setPrimaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have no primary material requirement even when it was explicitly called!");
        }
        this.primaryMaterialRequirement = tag;
        return this;
    }

    public AntimatterToolType setSecondaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have no secondary material requirement even when it was explicitly called!");
        }
        this.secondaryMaterialRequirement = tag;
        return this;
    }

    public AntimatterToolType setToolClass(Class<? extends IAntimatterTool> toolClass) {
        this.toolClass = toolClass;
        return this;
    }

    public boolean getBlockBreakability() {
        return this.blockBreakability;
    }

    public AntimatterToolType setBlockBreakability(boolean breakable) {
        this.blockBreakability = breakable;
        return this;
    }

    public AntimatterToolType setBaseQuality(int quality) {
        if (quality < 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have negative Base Quality!");
        }
        this.baseQuality = quality;
        return this;
    }

    public AntimatterToolType setUseSound(SoundEvent sound) {
        this.useSound = sound;
        return this;
    }

    public boolean getRepairability() {
        return this.repairable;
    }

    public AntimatterToolType setRepairability(boolean repairable) {
        this.repairable = repairable;
        return this;
    }

    public AntimatterToolType setOverlayLayers(int layers) {
        if (layers < 0) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " AntimatterToolType was set to have less than 0 overlayer layers!");
        }
        this.overlayLayers = layers;
        return this;
    }

    public AntimatterToolType setItemGroup(CreativeModeTab itemGroup) {
        this.itemGroup = itemGroup;
        return this;
    }

    public AntimatterToolType setUseAction(UseAnim useAction) {
        this.useAction = useAction;
        return this;
    }

    public void addBehaviour(IBehaviour<IAntimatterTool> ... behaviours) {
        Arrays.stream(behaviours).forEach(b -> this.behaviours.put((Object)b.getId(), b));
    }

    public IBehaviour<IAntimatterTool> getBehaviour(String id) {
        return (IBehaviour)this.behaviours.get((Object)id);
    }

    public void removeBehaviour(String ... ids) {
        Arrays.stream(ids).forEach(arg_0 -> this.behaviours.remove(arg_0));
    }

    public ItemStack getToolStack(Material primary, Material secondary) {
        return Objects.requireNonNull(AntimatterAPI.get(IAntimatterTool.class, this.id, this.getDomain())).asItemStack(primary, secondary);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Set<TagKey<Block>> getActualTags() {
        return this.TOOL_TYPES;
    }

    public TagKey<Block> getToolType() {
        return this.TOOL_TYPE;
    }

    public List<Component> getTooltip() {
        return this.tooltip;
    }

    public ImmutableMap<String, Function<ItemStack, ItemStack>> getBrokenItems() {
        return this.brokenItems;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean hasContainer() {
        return this.hasContainer;
    }

    public long getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public int[] getEnergyTiers() {
        return this.energyTiers;
    }

    public Class<? extends IAntimatterTool> getToolClass() {
        return this.toolClass;
    }

    public int getBaseQuality() {
        return this.baseQuality;
    }

    public float getBaseAttackDamage() {
        return this.baseAttackDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getUseDurability() {
        return this.useDurability;
    }

    public int getAttackDurability() {
        return this.attackDurability;
    }

    public int getCraftingDurability() {
        return this.craftingDurability;
    }

    public int getOverlayLayers() {
        return this.overlayLayers;
    }

    public CreativeModeTab getItemGroup() {
        return this.itemGroup;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    public TagKey<Item> getForgeTag() {
        return this.forgeTag;
    }

    public UseAnim getUseAction() {
        return this.useAction;
    }

    @Nullable
    public SoundEvent getUseSound() {
        return this.useSound;
    }

    @Nullable
    public IMaterialTag getPrimaryMaterialRequirement() {
        return this.primaryMaterialRequirement;
    }

    @Nullable
    public IMaterialTag getSecondaryMaterialRequirement() {
        return this.secondaryMaterialRequirement;
    }

    public Set<Block> getEffectiveBlocks() {
        return this.EFFECTIVE_BLOCKS;
    }

    public Set<net.minecraft.world.level.material.Material> getEffectiveMaterials() {
        return this.EFFECTIVE_MATERIALS;
    }

    public Object2ObjectMap<String, IBehaviour<IAntimatterTool>> getBehaviours() {
        return this.behaviours;
    }
}

