/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tool;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.util.TagUtils;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class AntimatterItemTier
implements Tier {
    private final Material primary;
    private final Material secondary;
    public static final AntimatterItemTier NULL = new AntimatterItemTier(Material.NULL, Material.NULL);
    private static final Int2ObjectMap<AntimatterItemTier> TIERS_LOOKUP = new Int2ObjectOpenHashMap();

    AntimatterItemTier(@Nonnull Material primary, @Nonnull Material secondary) {
        this.primary = primary.has(MaterialTags.TOOLS) ? primary : Material.NULL;
        this.secondary = secondary.has(MaterialTags.HANDLE) ? secondary : Material.NULL;
    }

    public static Optional<AntimatterItemTier> get(int key) {
        return Optional.ofNullable((AntimatterItemTier)TIERS_LOOKUP.get(key));
    }

    public static AntimatterItemTier getOrCreate(String primaryName, String secondaryName) {
        return (AntimatterItemTier)TIERS_LOOKUP.computeIfAbsent(Objects.hash(primaryName, secondaryName), m -> new AntimatterItemTier(Material.get(primaryName), Material.get(secondaryName)));
    }

    public static AntimatterItemTier getOrCreate(Material primary, Material secondary) {
        return (AntimatterItemTier)TIERS_LOOKUP.computeIfAbsent(Objects.hash(primary.hashCode(), secondary.hashCode()), m -> new AntimatterItemTier(primary, secondary));
    }

    public int m_6609_() {
        int secondaryUses = this.secondary.has(MaterialTags.HANDLE) ? MaterialTags.HANDLE.get(this.secondary).durability() : 0;
        return MaterialTags.TOOLS.get(this.primary).toolDurability() + secondaryUses;
    }

    public float m_6624_() {
        float secondarySpeed = this.secondary.has(MaterialTags.HANDLE) ? MaterialTags.HANDLE.get(this.secondary).speed() : 0.0f;
        return MaterialTags.TOOLS.get(this.primary).toolSpeed() + secondarySpeed;
    }

    public float m_6631_() {
        return MaterialTags.TOOLS.get(this.primary).toolDamage();
    }

    public int m_6604_() {
        if (this.primary == Material.NULL) {
            return 3;
        }
        return MaterialTags.TOOLS.get(this.primary).toolQuality();
    }

    public int m_6601_() {
        return (int)((float)this.m_6604_() + this.m_6624_());
    }

    public Ingredient m_6282_() {
        if (this.primary.has(AntimatterMaterialTypes.GEM)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("gems/".concat(this.primary.getId())));
        }
        if (this.primary.has(AntimatterMaterialTypes.INGOT)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("ingots/".concat(this.primary.getId())));
        }
        if (this.primary.has(AntimatterMaterialTypes.DUST)) {
            return Ingredient.m_204132_(TagUtils.getForgelikeItemTag("dusts/".concat(this.primary.getId())));
        }
        return Ingredient.f_43901_;
    }

    public Material getPrimary() {
        return this.primary;
    }

    public Material getSecondary() {
        return this.secondary;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AntimatterItemTier tier = (AntimatterItemTier)obj;
        return this.primary == tier.getPrimary() && this.secondary == tier.getSecondary();
    }

    public int hashCode() {
        return Objects.hash(this.primary.hashCode(), this.secondary.hashCode());
    }

    static {
        TIERS_LOOKUP.put(NULL.hashCode(), (Object)NULL);
    }
}

