/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.single;

import java.util.List;
import java.util.function.IntToLongFunction;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tool.AntimatterToolType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import tesseract.api.gt.IEnergyHandler;

public class TileEntityTransformer<T extends TileEntityTransformer<T>>
extends TileEntityMachine<T> {
    protected int voltage;
    protected int amperage;
    protected IntToLongFunction capFunc;

    public TileEntityTransformer(Machine<?> type, BlockPos pos, BlockState state, int amps) {
        this(type, pos, state, amps, v -> 512L + (long)v * 2L);
    }

    public TileEntityTransformer(Machine<?> type, BlockPos pos, BlockState state, int amps, IntToLongFunction capFunc) {
        super(type, pos, state);
        this.amperage = amps;
        this.capFunc = capFunc;
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, capFunc.applyAsLong(this.getMachineTier().getVoltage()), this.getMachineTier().getVoltage() * 4, this.getMachineTier().getVoltage(), this.amperage, this.amperage * 4){

            @Override
            public boolean canOutput(Direction direction) {
                return TileEntityTransformer.this.isDefaultMachineState() == (((TileEntityTransformer)this.tile).getFacing().m_122411_() != direction.m_122411_());
            }

            @Override
            public boolean canInput(Direction direction) {
                return !this.canOutput(direction);
            }
        });
    }

    @Override
    public InteractionResult onInteractServer(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, AntimatterToolType type) {
        if (type == AntimatterDefaultTools.SOFT_HAMMER && hand == InteractionHand.MAIN_HAND) {
            this.toggleMachine();
            this.energyHandler.ifPresent(h -> {
                long temp = h.getOutputAmperage();
                h.setOutputAmperage(h.getInputAmperage());
                h.setInputAmperage(temp);
                temp = h.getOutputVoltage();
                h.setOutputVoltage(h.getInputVoltage());
                h.setInputVoltage(temp);
                this.invalidateCap(IEnergyHandler.class);
                player.m_6352_((Component)new TextComponent((this.isDefaultMachineState() ? "Step Down, In: " : "Step Up, In") + h.getInputVoltage() + "V@" + h.getInputAmperage() + "Amp, Out: " + h.getOutputVoltage() + "V@" + h.getOutputAmperage() + "Amp"), player.m_142081_());
            });
            return InteractionResult.SUCCESS;
        }
        return super.onInteractServer(state, world, pos, player, hand, hit, type);
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        this.voltage = this.getMachineTier().getVoltage();
    }

    @Override
    public MachineState getDefaultMachineState() {
        return MachineState.ACTIVE;
    }

    @Override
    public List<String> getInfo() {
        List<String> info = super.getInfo();
        this.energyHandler.ifPresent(h -> {
            info.add("Voltage In: " + h.getInputVoltage());
            info.add("Voltage Out: " + h.getOutputVoltage());
            info.add("Amperage In: " + h.getInputAmperage());
            info.add("Amperage Out: " + h.getOutputAmperage());
        });
        return info;
    }
}

