/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.single;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import muramasa.antimatter.capability.EnergyHandler;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.gt.GTTransaction;

public class TileEntityInfiniteStorage<T extends TileEntityInfiniteStorage<T>>
extends TileEntityMachine<T>
implements IInfoRenderer<InfiniteStorageWidget> {
    public TileEntityInfiniteStorage(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, Long.MAX_VALUE, Long.MAX_VALUE, 0, 32, 0, 4){

            public GTTransaction extract(GTTransaction.Mode mode) {
                return new GTTransaction(this.availableAmpsOutput(), this.getOutputVoltage(), this::extractEnergy);
            }

            @Override
            public boolean extractEnergy(GTTransaction.TransferData data) {
                this.getState().receive(false, data.getAmps(false));
                return true;
            }

            @Override
            public boolean canOutput(Direction direction) {
                return ((TileEntityInfiniteStorage)this.tile).getFacing() == direction;
            }
        });
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            int[] data = ((GuiEvents.GuiEvent)event).data;
            this.energyHandler.ifPresent(h -> {
                int voltage = (int)h.getOutputVoltage();
                int amperage = (int)h.getOutputAmperage();
                boolean shiftHold = data[0] != 0;
                switch (data[1]) {
                    case 0: {
                        voltage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 1: {
                        voltage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 2: {
                        amperage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 3: {
                        amperage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 4: {
                        voltage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 5: {
                        voltage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 6: {
                        amperage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 7: {
                        amperage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 8: {
                        voltage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 9: {
                        voltage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 10: {
                        amperage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 11: {
                        amperage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 12: {
                        voltage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 13: {
                        voltage *= shiftHold ? 16 : 2;
                        break;
                    }
                    case 14: {
                        amperage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 15: {
                        amperage *= shiftHold ? 16 : 2;
                    }
                }
                if (voltage < 0) {
                    voltage = 0;
                }
                if (amperage < 0) {
                    amperage = 0;
                }
                h.setOutputVoltage(voltage);
                h.setOutputAmperage(amperage);
            });
        }
    }

    @Override
    public List<String> getInfo() {
        List<String> info = super.getInfo();
        this.energyHandler.ifPresent(h -> {
            info.add("Voltage Out: " + h.getOutputVoltage());
            info.add("Amperage Out: " + h.getOutputAmperage());
        });
        return info;
    }

    @Override
    public int drawInfo(InfiniteStorageWidget widget, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Control Panel", (float)(left + 43), (float)(top + 21), 0xFAFAFF);
        renderer.m_92883_(stack, "VOLT: " + widget.voltage, (float)(left + 43), (float)(top + 40), 0xFAFAFF);
        renderer.m_92883_(stack, "TIER: " + Tier.getTier(widget.voltage < 0 ? -widget.voltage : widget.voltage).getId().toUpperCase(), (float)(left + 43), (float)(top + 48), 0xFAFAFF);
        renderer.m_92883_(stack, "AMP: " + widget.amperage, (float)(left + 43), (float)(top + 56), 0xFAFAFF);
        renderer.m_92883_(stack, "SUM: " + (long)(widget.amperage * widget.voltage), (float)(left + 43), (float)(top + 64), 0xFAFAFF);
        return 72;
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfiniteStorageWidget.build());
    }

    public static class InfiniteStorageWidget
    extends InfoRenderWidget<InfiniteStorageWidget> {
        public int amperage = 0;
        public int voltage = 0;

        protected InfiniteStorageWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<InfiniteStorageWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityInfiniteStorage m = (TileEntityInfiniteStorage)this.gui.handler;
            this.gui.syncInt(() -> Math.toIntExact(m.energyHandler.map(EnergyHandler::getOutputAmperage).orElse(0L)), i -> {
                this.amperage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> Math.toIntExact(m.energyHandler.map(EnergyHandler::getOutputVoltage).orElse(0L)), i -> {
                this.voltage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return InfiniteStorageWidget.builder((a, b) -> new InfiniteStorageWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

