/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.single;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.single.TileEntityTransformer;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityDigitalTransformer<T extends TileEntityDigitalTransformer<T>>
extends TileEntityTransformer<T>
implements IInfoRenderer<DigitalTransformerWidget> {
    public TileEntityDigitalTransformer(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 0, v -> 8192L + (long)v * 64L);
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            this.energyHandler.ifPresent(h -> {
                GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
                int[] data = ev.data;
                boolean shiftHold = data[0] != 0;
                switch (data[1]) {
                    case 0: {
                        this.voltage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 1: {
                        this.voltage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 2: {
                        this.amperage /= shiftHold ? 512 : 64;
                        break;
                    }
                    case 3: {
                        this.amperage -= shiftHold ? 512 : 64;
                        break;
                    }
                    case 4: {
                        this.voltage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 5: {
                        this.voltage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 6: {
                        this.amperage /= shiftHold ? 16 : 2;
                        break;
                    }
                    case 7: {
                        this.amperage -= shiftHold ? 16 : 1;
                        break;
                    }
                    case 8: {
                        this.voltage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 9: {
                        this.voltage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 10: {
                        this.amperage += shiftHold ? 512 : 64;
                        break;
                    }
                    case 11: {
                        this.amperage *= shiftHold ? 512 : 64;
                        break;
                    }
                    case 12: {
                        this.voltage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 13: {
                        this.voltage *= shiftHold ? 16 : 2;
                        break;
                    }
                    case 14: {
                        this.amperage += shiftHold ? 16 : 1;
                        break;
                    }
                    case 15: {
                        this.amperage *= shiftHold ? 16 : 2;
                    }
                }
                this.amperage = Math.max(this.amperage, 0);
                this.voltage = Math.max(this.voltage, 0);
                this.setMachineState((long)(this.amperage * this.voltage) >= 0L ? this.getDefaultMachineState() : MachineState.DISABLED);
                if (this.isDefaultMachineState()) {
                    h.setInputVoltage(this.getMachineTier().getVoltage());
                    h.setOutputVoltage(this.voltage);
                    h.setInputAmperage(this.amperage);
                    h.setOutputVoltage(1L);
                } else {
                    h.setInputVoltage(this.voltage);
                    h.setOutputVoltage(this.getMachineTier().getVoltage());
                    h.setInputAmperage(1L);
                    h.setOutputVoltage(this.amperage);
                }
            });
        }
    }

    @Override
    public int drawInfo(DigitalTransformerWidget widget, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Control Panel", (float)(left + 43), (float)(top + 21), 0xFAFAFF);
        renderer.m_92883_(stack, "VOLT: " + widget.voltage, (float)(left + 43), (float)(top + 40), 0xFAFAFF);
        renderer.m_92883_(stack, "TIER: " + Tier.getTier(widget.voltage < 0 ? -widget.voltage : widget.voltage).getId().toUpperCase(), (float)(left + 43), (float)(top + 48), 0xFAFAFF);
        renderer.m_92883_(stack, "AMP: " + widget.amperage, (float)(left + 43), (float)(top + 56), 0xFAFAFF);
        renderer.m_92883_(stack, "SUM: " + (long)(widget.amperage * widget.voltage), (float)(left + 43), (float)(top + 64), 0xFAFAFF);
        return 72;
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(DigitalTransformerWidget.build());
    }

    public static class DigitalTransformerWidget
    extends InfoRenderWidget<DigitalTransformerWidget> {
        public int amperage = 0;
        public int voltage = 0;

        protected DigitalTransformerWidget(GuiInstance gui, IGuiElement parent, IInfoRenderer<DigitalTransformerWidget> renderer) {
            super(gui, parent, renderer);
        }

        @Override
        public void init() {
            super.init();
            TileEntityDigitalTransformer m = (TileEntityDigitalTransformer)this.gui.handler;
            this.gui.syncInt(() -> m.amperage, i -> {
                this.amperage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
            this.gui.syncInt(() -> m.voltage, i -> {
                this.voltage = i;
            }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        }

        public static WidgetSupplier build() {
            return DigitalTransformerWidget.builder((a, b) -> new DigitalTransformerWidget((GuiInstance)a, (IGuiElement)b, (IInfoRenderer)((Object)a.handler)));
        }
    }
}

