/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.pipe;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.CoverHandler;
import muramasa.antimatter.capability.Holder;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.capability.pipe.PipeCoverHandler;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.BackgroundWidget;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.TileEntityTickable;
import muramasa.antimatter.tile.pipe.TileEntityCable;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.TesseractPlatformUtils;
import tesseract.api.IConnectable;
import tesseract.graph.Connectivity;

public abstract class TileEntityPipe<T extends PipeType<T>>
extends TileEntityTickable<TileEntityPipe<T>>
implements IMachineHandler,
MenuProvider,
IGuiHandler,
IConnectable {
    protected T type;
    protected PipeSize size;
    public final LazyOptional<PipeCoverHandler<?>> coverHandler;
    private byte connection;
    protected Holder pipeCapHolder;

    public TileEntityPipe(T type, BlockPos pos, BlockState state) {
        super(((PipeType)type).getTileType(), pos, state);
        this.size = this.getPipeSize(state);
        this.type = this.getPipeType(state);
        this.coverHandler = LazyOptional.of(() -> new PipeCoverHandler<TileEntityPipe>(this));
        this.pipeCapHolder = new Holder(this.getCapClass(), this.dispatch);
    }

    @Override
    public String handlerDomain() {
        return ((PipeType)this.getPipeType()).domain;
    }

    public void onLoad() {
        if (this.isServerSide()) {
            this.register();
        }
    }

    public Holder getPipeCapHolder() {
        return this.pipeCapHolder;
    }

    public boolean isConnector() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING) == false;
    }

    public void onBlockUpdate(BlockPos neighbor) {
        Direction facing = Utils.getOffsetFacing(this.m_58899_(), neighbor);
        this.coverHandler.ifPresent(h -> h.get(facing).onBlockUpdate());
    }

    @Override
    public void onRemove() {
        this.coverHandler.ifPresent(CoverHandler::onRemove);
        if (this.isServerSide()) {
            this.dispatch.invalidate();
            this.deregisterTesseract();
        }
    }

    public T getPipeType() {
        if (this.type == null) {
            this.type = this.getPipeType(this.m_58900_());
        }
        return this.type;
    }

    private T getPipeType(BlockState state) {
        return ((BlockPipe)state.m_60734_()).getType();
    }

    public PipeSize getPipeSize() {
        if (this.size == null) {
            this.size = this.getPipeSize(this.m_58900_());
        }
        return this.size;
    }

    private PipeSize getPipeSize(BlockState state) {
        return ((BlockPipe)state.m_60734_()).getSize();
    }

    public TileEntityPipe<?> getPipe(Direction side) {
        return this.getPipe(this.m_58899_().m_142300_(side));
    }

    public TileEntityPipe<?> getPipe(BlockPos side) {
        BlockEntity tile = this.m_58904_().m_7702_(side);
        if (!(tile instanceof TileEntityPipe)) {
            return null;
        }
        TileEntityPipe<T> pipe = (TileEntityPipe<T>)tile;
        return pipe.getCapClass() == this.getCapClass() ? pipe : null;
    }

    public void toggleConnection(Direction side) {
        if (this.connects(side)) {
            this.clearConnection(side);
        } else {
            this.setConnection(side);
        }
    }

    public void setConnection(Direction side) {
        if (this.connects(side)) {
            return;
        }
        if (this.blocksSide(side)) {
            return;
        }
        TileEntityPipe<?> pipe = this.getPipe(side);
        this.connection = Connectivity.set((byte)this.connection, (int)side.m_122411_());
        boolean ok = this.validate(side);
        if (!ok && pipe == null && this.f_58857_.m_8055_(this.f_58858_.m_142300_(side)).m_155947_()) {
            this.connection = Connectivity.clear((byte)this.connection, (int)side.m_122411_());
            return;
        }
        this.refreshConnection();
        if (pipe != null) {
            pipe.setConnection(side.m_122424_());
        }
    }

    public void clearConnection(Direction side) {
        if (!this.connects(side)) {
            return;
        }
        this.connection = Connectivity.clear((byte)this.connection, (int)side.m_122411_());
        this.dispatch.invalidate(side);
        this.refreshConnection();
        TileEntityPipe<?> pipe = this.getPipe(side);
        if (pipe != null) {
            pipe.clearConnection(side.m_122424_());
        }
    }

    public boolean canConnect(int side) {
        return Connectivity.has((byte)this.connection, (int)side);
    }

    public abstract Class<?> getCapClass();

    public void refreshConnection() {
        this.sidedSync(true);
        if (this.isServerSide() && this.isConnector()) {
            this.deregisterTesseract();
            this.register();
        }
    }

    protected abstract void register();

    protected abstract boolean deregister();

    private boolean deregisterTesseract() {
        byte old = this.connection;
        this.connection = 0;
        boolean ok = this.deregister();
        this.connection = old;
        return ok;
    }

    public boolean connects(Direction direction) {
        return Connectivity.has((byte)this.connection, (int)direction.m_122411_());
    }

    public boolean validate(Direction dir) {
        if (!this.connects(dir)) {
            return false;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_142300_(dir));
        if (state.m_60734_() instanceof BlockPipe && !((Boolean)state.m_61143_((Property)BlockPipe.TICKING)).booleanValue()) {
            return false;
        }
        return !this.blocksSide(dir);
    }

    public boolean onCoverUpdate(boolean remove, boolean hasNonEmpty, Direction side, ICover old, ICover stack) {
        if (stack.blocksCapability(this.getCapClass(), side)) {
            this.clearConnection(side);
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING)).booleanValue()) {
            if (remove && !hasNonEmpty) {
                this.toggleTickingState();
                return true;
            }
        } else if (!remove && hasNonEmpty) {
            this.toggleTickingState();
            return true;
        }
        return false;
    }

    private void toggleTickingState() {
        CompoundTag nbt = this.m_187480_();
        BlockState old = this.m_58900_();
        BlockState new_s = (BlockState)this.m_58900_().m_61124_((Property)BlockPipe.TICKING, (Comparable)Boolean.valueOf((Boolean)this.m_58900_().m_61143_((Property)BlockPipe.TICKING) == false));
        this.f_58857_.m_7731_(this.m_58899_(), new_s, 10);
        TileEntityPipe pipe = (TileEntityPipe)this.f_58857_.m_7702_(this.m_58899_());
        if (pipe != this && pipe != null) {
            pipe.m_142466_(nbt);
            if (pipe.isConnector()) {
                pipe.register();
            }
            this.f_58857_.m_7260_(this.m_58899_(), old, new_s, 3);
        }
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.coverHandler.ifPresent(CoverHandler::onUpdate);
    }

    public CoverFactory[] getValidCovers() {
        return (CoverFactory[])AntimatterAPI.all(CoverFactory.class).stream().filter(t -> {
            try {
                return !t.get().get(ICoverHandler.empty(this), t.getValidTier(), Direction.SOUTH, (CoverFactory)t).blocksCapability(this.getCapClass(), null);
            }
            catch (Exception ex) {
                return false;
            }
        }).toArray(CoverFactory[]::new);
    }

    public ICover[] getAllCovers() {
        return this.coverHandler.map(CoverHandler::getAll).orElse(new ICover[0]);
    }

    public ICover getCover(Direction side) {
        return this.coverHandler.map(h -> h.get(side)).orElse(null);
    }

    public boolean blocksSide(Direction side) {
        return this.coverHandler.map(t -> t.blocksCapability(this.getCapClass(), side)).orElse(false);
    }

    @Nonnull
    public <U> LazyOptional<U> getCoverCapability(@Nonnull Class<U> cap, @Nullable Direction side) {
        if (side == null) {
            return LazyOptional.empty();
        }
        if (cap == this.getCapClass()) {
            return this.pipeCapHolder.side(side).cast();
        }
        if (TesseractPlatformUtils.isFeCap(cap) && this instanceof TileEntityCable) {
            return this.pipeCapHolder.side(side).cast();
        }
        return LazyOptional.empty();
    }

    public void m_142466_(CompoundTag tag) {
        byte newConnection;
        super.m_142466_(tag);
        if (tag.m_128441_("v")) {
            this.coverHandler.ifPresent(t -> t.deserializeNBT(tag.m_128469_("v")));
        }
        if ((newConnection = tag.m_128445_("c")) != this.connection && this.f_58857_ != null && this.f_58857_.f_46443_) {
            Utils.markTileForRenderUpdate(this);
        }
        if (this.connection != newConnection && this.f_58857_ != null) {
            for (int i = 0; i < Ref.DIRS.length; ++i) {
                boolean secondHas;
                boolean different;
                boolean firstHas = Connectivity.has((byte)this.connection, (int)i);
                boolean bl = different = firstHas != (secondHas = Connectivity.has((byte)newConnection, (int)i));
                if (!different) continue;
                if (secondHas) {
                    this.setConnection(Ref.DIRS[i]);
                    continue;
                }
                this.clearConnection(Ref.DIRS[i]);
            }
        } else if (this.f_58857_ == null) {
            this.connection = tag.m_128445_("c");
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.coverHandler.ifPresent(h -> tag.m_128365_("v", (Tag)h.serializeNBT()));
        tag.m_128344_("c", this.connection);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    public List<String> getInfo() {
        List<String> info = super.getInfo();
        info.add("Pipe Type: " + ((PipeType)this.getPipeType()).getId());
        info.add("Pipe Size: " + this.getPipeSize().getId());
        return info;
    }

    @Override
    public boolean isRemote() {
        return this.m_58904_().f_46443_;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation("antimatter", "textures/gui/empty_multi.png");
    }

    @Override
    public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
        return null;
    }

    public Component m_5446_() {
        return new TextComponent(((PipeType)this.type).getTypeName());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        return Data.PIPE_MENU_HANDLER.menu(this, p_createMenu_2_, p_createMenu_1_);
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        instance.addWidget(BackgroundWidget.build(instance.handler.getGuiTexture(), instance.handler.guiSize(), instance.handler.guiHeight()));
    }
}

