/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.TesseractItemCapability;
import tesseract.api.item.IItemPipe;

public class TileEntityItemPipe<T extends ItemPipe<T>>
extends TileEntityPipe<T>
implements IItemPipe,
Dispatch.Sided<IItemHandler>,
IInfoRenderer<InfoRenderWidget.TesseractItemWidget> {
    private int holder;

    public TileEntityItemPipe(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.pipeCapHolder.set(() -> this);
        this.holder = 0;
    }

    @Override
    protected void register() {
        TesseractGraphWrappers.ITEM.registerConnector(this.m_58904_(), this.m_58899_().m_121878_(), (IConnectable)this, this.isConnector());
    }

    @Override
    protected boolean deregister() {
        return TesseractGraphWrappers.ITEM.remove(this.m_58904_(), this.m_58899_().m_121878_());
    }

    @Override
    public void onBlockUpdate(BlockPos neighbour) {
        super.onBlockUpdate(neighbour);
        TesseractGraphWrappers.ITEM.blockUpdate(this.m_58904_(), this.m_58899_().m_121878_(), neighbour.m_121878_());
    }

    public int getCapacity() {
        return ((ItemPipe)this.getPipeType()).getCapacity(this.getPipeSize());
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (tile == null) {
            return false;
        }
        return TesseractCapUtils.getItemHandler((BlockEntity)tile, (Direction)dir.m_122424_()).isPresent();
    }

    @Override
    public Class<?> getCapClass() {
        return IItemHandler.class;
    }

    @Override
    public LazyOptional<IItemHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new TesseractItemCapability((BlockEntity)this, side, !this.isConnector(), (stack, in, out, simulate) -> this.coverHandler.ifPresent(t -> t.onTransfer(stack, in, out, simulate))));
    }

    @Override
    public LazyOptional<? extends IItemHandler> forNullSide() {
        return this.forSide(null);
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.m_58904_().m_46467_() % 20L == 0L) {
            this.setHolder(0);
        }
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfoRenderWidget.TesseractItemWidget.build().setPos(10, 10));
    }

    @Override
    public int drawInfo(InfoRenderWidget.TesseractItemWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Total transferred in net: " + instance.transferred, (float)left, (float)top, 0xFAFAFF);
        renderer.m_92883_(stack, "Cable transfers (stacks): " + instance.cableTransferred, (float)left, (float)(top + 8), 0xFAFAFF);
        return 16;
    }

    public int getHolder() {
        return this.holder;
    }

    public void setHolder(int holder) {
        this.holder = holder;
    }
}

