/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.pipe;

import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.machine.DefaultHeatHandler;
import muramasa.antimatter.pipe.types.HeatPipe;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.util.int3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.heat.HeatTransaction;
import tesseract.api.heat.IHeatHandler;
import tesseract.api.heat.IHeatNode;
import tesseract.api.heat.IHeatPipe;

public class TileEntityHeatPipe<T extends HeatPipe<T>>
extends TileEntityPipe<T>
implements IHeatPipe {
    public TileEntityHeatPipe(T type, final BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.pipeCapHolder.set(() -> new DefaultHeatHandler(this, 800 * type.conductivity, type.conductivity){

            @Override
            public void update(boolean active) {
                HeatTransaction tx;
                boolean doTransfer = true;
                if (doTransfer && (tx = this.extract()).isValid()) {
                    int3 mutPos = new int3();
                    for (Direction dir : Ref.DIRS) {
                        if (!TileEntityHeatPipe.this.connects(dir) || !TileEntityHeatPipe.this.validate(dir)) continue;
                        mutPos.set(pos);
                        mutPos = mutPos.offset(1, dir);
                        BlockEntity ent = TileEntityHeatPipe.this.f_58857_.m_7702_((BlockPos)mutPos);
                        if (ent == null) continue;
                        TesseractCapUtils.getHeatHandler((BlockEntity)ent, (Direction)dir.m_122424_()).ifPresent(t -> t.insert(tx));
                    }
                    tx.commit();
                    this.currentHeat = Math.max(0, this.currentHeat - (int)((double)this.temperaturesize * 0.01));
                }
            }
        });
    }

    @Override
    public Class<?> getCapClass() {
        return IHeatHandler.class;
    }

    @Override
    protected void register() {
        TesseractGraphWrappers.HEAT_CONTROLLER.registerConnector(this.m_58904_(), this.m_58899_().m_121878_(), (IConnectable)this, this.isConnector());
    }

    @Override
    protected boolean deregister() {
        return TesseractGraphWrappers.HEAT_CONTROLLER.remove(this.f_58857_, this.m_58899_().m_121878_());
    }

    public HeatTransaction extract() {
        return this.pipeCapHolder.nullSide().map(IHeatNode::extract).orElse(null);
    }

    public void insert(HeatTransaction transaction) {
        this.pipeCapHolder.nullSide().ifPresent(t -> t.insert(transaction));
    }

    public int getHeat() {
        return this.pipeCapHolder.nullSide().map(IHeatNode::getHeat).orElse(0);
    }

    public int getHeatCap() {
        return this.pipeCapHolder.nullSide().map(IHeatNode::getHeatCap).orElse(0);
    }

    public int getTemperature() {
        return this.pipeCapHolder.nullSide().map(IHeatNode::getTemperature).orElse(0);
    }

    public void update(boolean active) {
        this.pipeCapHolder.nullSide().ifPresent(t -> t.update(active));
    }

    public int temperatureCoefficient() {
        return ((HeatPipe)this.type).conductivity;
    }

    public CompoundTag serializeNBT() {
        return this.pipeCapHolder.nullSide().map(h -> (CompoundTag)h.serializeNBT()).orElse(null);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.pipeCapHolder.nullSide().ifPresent(h -> h.deserializeNBT((Tag)nbt));
    }
}

