/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.pipe.PipeFluidHandler;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.TesseractFluidCapability;
import tesseract.api.fluid.FluidHolder;
import tesseract.api.fluid.IFluidPipe;

public class TileEntityFluidPipe<T extends FluidPipe<T>>
extends TileEntityPipe<T>
implements IFluidPipe,
Dispatch.Sided<IFluidHandler>,
IInfoRenderer<InfoRenderWidget.TesseractFluidWidget> {
    protected LazyOptional<PipeFluidHandler> fluidHandler;
    private FluidHolder holder;

    public TileEntityFluidPipe(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (this.fluidHandler == null) {
            this.fluidHandler = LazyOptional.empty();
        }
        this.pipeCapHolder.set(() -> this);
    }

    @Override
    public void onLoad() {
        this.holder = new FluidHolder((IFluidPipe)this);
        super.onLoad();
    }

    @Override
    public void onBlockUpdate(BlockPos neighbour) {
        super.onBlockUpdate(neighbour);
        TesseractGraphWrappers.FLUID.blockUpdate(this.m_58904_(), this.m_58899_().m_121878_(), neighbour.m_121878_());
    }

    @Override
    protected void register() {
        TesseractGraphWrappers.FLUID.registerConnector(this.m_58904_(), this.m_58899_().m_121878_(), (IConnectable)this, this.isConnector());
    }

    @Override
    protected boolean deregister() {
        return TesseractGraphWrappers.FLUID.remove(this.m_58904_(), this.m_58899_().m_121878_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("fl")) {
            this.fluidHandler.ifPresent(t -> t.deserializeNBT(tag.m_128469_("fl")));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fluidHandler.ifPresent(t -> tag.m_128365_("fl", (Tag)t.serializeNBT()));
    }

    @Override
    public void onRemove() {
        this.fluidHandler.ifPresent(FluidHandler::onRemove);
        this.fluidHandler.invalidate();
        super.onRemove();
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfoRenderWidget.TesseractFluidWidget.build().setPos(10, 10));
    }

    public boolean isGasProof() {
        return ((FluidPipe)this.getPipeType()).isGasProof();
    }

    public FluidHolder getHolder() {
        return this.holder;
    }

    public int getCapacity() {
        return ((FluidPipe)this.getPipeType()).getCapacity(this.getPipeSize());
    }

    public int getPressure() {
        return ((FluidPipe)this.getPipeType()).getPressure(this.getPipeSize());
    }

    public int getTemperature() {
        return ((FluidPipe)this.getPipeType()).getTemperature();
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        return TesseractCapUtils.getFluidHandler((Level)this.f_58857_, (BlockPos)this.m_58899_().m_142300_(dir), (Direction)dir.m_122424_()).isPresent();
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.getHolder().tick(this.m_58904_().m_46467_());
    }

    @Override
    public Class<?> getCapClass() {
        return IFluidHandler.class;
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new TesseractFluidCapability((BlockEntity)this, side, !this.isConnector(), (stack, in, out, simulate) -> this.coverHandler.ifPresent(t -> t.onTransfer(stack, in, out, simulate))));
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forNullSide() {
        return this.forSide(null);
    }

    @Override
    public int drawInfo(InfoRenderWidget.TesseractFluidWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Pressure used: " + instance.stack.getAmount(), (float)left, (float)top, 0xFAFAFF);
        renderer.m_92883_(stack, "Pressure total: " + this.getPressure() * 20, (float)left, (float)(top + 8), 0xFAFAFF);
        renderer.m_92883_(stack, "Fluid: " + FluidPlatformUtils.getFluidId((Fluid)instance.stack.getFluid()).toString(), (float)left, (float)(top + 16), 0xFAFAFF);
        renderer.m_92883_(stack, "(Above only in intersection)", (float)left, (float)(top + 24), 0xFAFAFF);
        return 32;
    }

    @Override
    public List<String> getInfo() {
        List<String> list = super.getInfo();
        this.fluidHandler.ifPresent(t -> {
            for (int i = 0; i < t.getTanks(); ++i) {
                FluidStack stack = t.getFluidInTank(i);
                list.add(FluidPlatformUtils.getFluidId((Fluid)stack.getFluid()).toString() + " " + stack.getAmount() + " mb.");
            }
        });
        list.add("Pressure: " + ((FluidPipe)this.getPipeType()).getPressure(this.getPipeSize()));
        list.add("Capacity: " + ((FluidPipe)this.getPipeType()).getCapacity(this.getPipeSize()));
        list.add("Max temperature: " + ((FluidPipe)this.getPipeType()).getTemperature());
        list.add(((FluidPipe)this.getPipeType()).isGasProof() ? "Gas proof." : "Cannot handle gas.");
        return list;
    }

    private /* synthetic */ PipeFluidHandler lambda$forSide$4() {
        return new PipeFluidHandler(this, 1000 * (this.getPipeSize().ordinal() + 1), 1000, 1, 0);
    }

    private /* synthetic */ PipeFluidHandler lambda$new$0() {
        return new PipeFluidHandler(this, 1000 * (this.getPipeSize().ordinal() + 1), 1000, 1, 0);
    }
}

