/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.pipe.BlockCable;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.PipeType;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.TesseractGTCapability;
import tesseract.api.gt.GTHolder;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTCable;

public class TileEntityCable<T extends PipeType<T>>
extends TileEntityPipe<T>
implements IGTCable,
Dispatch.Sided<IEnergyHandler>,
IInfoRenderer<InfoRenderWidget.TesseractGTWidget> {
    private long holder;

    public TileEntityCable(T type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.pipeCapHolder.set(() -> this);
    }

    @Override
    public void onLoad() {
        this.holder = GTHolder.create((IGTCable)this, (long)0L);
        super.onLoad();
    }

    @Override
    public CoverFactory[] getValidCovers() {
        return new CoverFactory[0];
    }

    @Override
    protected void register() {
        TesseractGraphWrappers.GT_ENERGY.registerConnector(this.m_58904_(), this.m_58899_().m_121878_(), (IConnectable)this, this.isConnector());
    }

    @Override
    protected boolean deregister() {
        return TesseractGraphWrappers.GT_ENERGY.remove(this.m_58904_(), this.m_58899_().m_121878_());
    }

    @Override
    public Class<?> getCapClass() {
        return IEnergyHandler.class;
    }

    @Override
    public void onBlockUpdate(BlockPos neighbour) {
        super.onBlockUpdate(neighbour);
        TesseractGraphWrappers.GT_ENERGY.blockUpdate(this.m_58904_(), this.m_58899_().m_121878_(), neighbour.m_121878_());
    }

    public int getVoltage() {
        return ((Cable)this.getPipeType()).getTier().getVoltage();
    }

    public boolean insulated() {
        return ((BlockCable)this.m_58900_().m_60734_()).insulated;
    }

    public long getHolder() {
        return this.holder;
    }

    public void setHolder(long holder) {
        this.holder = holder;
    }

    public int getLoss() {
        return ((Cable)this.getPipeType()).getLoss();
    }

    public int getAmps() {
        return ((Cable)this.getPipeType()).getAmps(this.getPipeSize());
    }

    @Override
    public boolean connects(Direction direction) {
        return this.canConnect(direction.m_122411_());
    }

    @Override
    public boolean validate(Direction dir) {
        if (!super.validate(dir)) {
            return false;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (tile == null) {
            return false;
        }
        return TesseractCapUtils.getEnergyHandler((BlockEntity)tile, (Direction)dir.m_122424_()).isPresent();
    }

    @Override
    protected void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.setHolder(GTHolder.create((IGTCable)this, (long)0L));
    }

    @Override
    public LazyOptional<IEnergyHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new TesseractGTCapability((BlockEntity)this, side, !this.isConnector(), (stack, in, out, simulate) -> this.coverHandler.ifPresent(t -> t.onTransfer(stack, in, out, simulate))));
    }

    @Override
    public LazyOptional<IEnergyHandler> forNullSide() {
        return this.forSide(null);
    }

    @Override
    public void addWidgets(GuiInstance instance, IGuiElement parent) {
        super.addWidgets(instance, parent);
        instance.addWidget(InfoRenderWidget.TesseractGTWidget.build().setPos(10, 10));
    }

    @Override
    public int drawInfo(InfoRenderWidget.TesseractGTWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, "Amp average: " + instance.ampAverage, (float)left, (float)top, 0xFAFAFF);
        renderer.m_92883_(stack, "Average extracted: " + (double)instance.voltAverage / 20.0, (float)left, (float)(top + 16), 0xFAFAFF);
        renderer.m_92883_(stack, "Average inserted: " + (double)(instance.voltAverage - instance.loss) / 20.0, (float)left, (float)(top + 24), 0xFAFAFF);
        renderer.m_92883_(stack, "Loss average: " + (double)instance.loss / 20.0, (float)left, (float)(top + 32), 0xFAFAFF);
        return 40;
    }
}

