/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.multi;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.capability.machine.MultiMachineEnergyHandler;
import muramasa.antimatter.capability.machine.MultiMachineFluidHandler;
import muramasa.antimatter.capability.machine.MultiMachineItemHandler;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.InfoRenderWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.heat.IHeatHandler;

public class TileEntityMultiMachine<T extends TileEntityMultiMachine<T>>
extends TileEntityBasicMultiMachine<T>
implements IInfoRenderer<InfoRenderWidget.MultiRenderWidget> {
    protected long EUt;
    protected List<IHeatHandler> heatHandlers = Collections.emptyList();

    public TileEntityMultiMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has(MachineFlag.ITEM) || type.has(MachineFlag.CELL)) {
            this.itemHandler.set(() -> new MultiMachineItemHandler<TileEntityMultiMachine>(this));
        }
        if (type.has(MachineFlag.ENERGY)) {
            this.energyHandler.set(() -> new MultiMachineEnergyHandler<TileEntityMultiMachine>(this));
        }
        if (type.has(MachineFlag.FLUID)) {
            this.fluidHandler.set(() -> new MultiMachineFluidHandler<TileEntityMultiMachine>(this));
        }
    }

    public List<IHeatHandler> getHeatHandlers() {
        return this.heatHandlers;
    }

    @Override
    public Tier getPowerLevel() {
        return this.energyHandler.map(t -> ((MultiMachineEnergyHandler)t).getAccumulatedPower()).orElse(super.getPowerLevel());
    }

    @Override
    public void afterStructureFormed() {
        this.result.components.forEach((k, v) -> v.forEach(c -> c.onStructureFormed(this)));
        this.itemHandler.ifPresent(handle -> ((MultiMachineItemHandler)handle).onStructureBuild());
        this.energyHandler.ifPresent(handle -> ((MultiMachineEnergyHandler)handle).onStructureBuild());
        this.fluidHandler.ifPresent(handle -> ((MultiMachineFluidHandler)handle).onStructureBuild());
        List heats = (List)this.result.components.get((Object)"components");
        this.heatHandlers = heats != null ? heats.stream().map(IComponentHandler::getHeatHandler).filter(Optional::isPresent).map(Optional::get).toList() : Collections.emptyList();
    }

    @Override
    public void onStructureInvalidated() {
        this.result.components.forEach((k, v) -> v.forEach(c -> c.onStructureInvalidated(this)));
        this.itemHandler.ifPresent(handle -> ((MultiMachineItemHandler)handle).invalidate());
        this.energyHandler.ifPresent(handle -> ((MultiMachineEnergyHandler)handle).invalidate());
        this.fluidHandler.ifPresent(handle -> ((MultiMachineFluidHandler)handle).invalidate());
        this.heatHandlers = Collections.emptyList();
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
    }

    @Override
    public long getMaxInputVoltage() {
        List<IComponentHandler> hatches = this.getComponents("hatch_energy");
        return hatches.size() >= 1 ? hatches.stream().mapToLong(t -> t.getEnergyHandler().map(eh -> eh.getInputAmperage() * eh.getInputVoltage()).orElse(0L)).sum() : (long)Ref.V[0];
    }

    public WidgetSupplier getInfoWidget() {
        return InfoRenderWidget.MultiRenderWidget.build().setPos(10, 10);
    }

    @Override
    public int drawInfo(InfoRenderWidget.MultiRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, this.m_5446_().getString(), (float)left, (float)top, 0xFAFAFF);
        if (this.getMachineState() != MachineState.ACTIVE) {
            renderer.m_92883_(stack, "Inactive.", (float)left, (float)(top + 8), 0xFAFAFF);
            return 16;
        }
        if (instance.drawActiveInfo()) {
            renderer.m_92883_(stack, "Progress: " + instance.currentProgress + "/" + instance.maxProgress, (float)left, (float)(top + 8), 0xFAFAFF);
            renderer.m_92883_(stack, "Overclock: " + instance.overclock, (float)left, (float)(top + 16), 0xFAFAFF);
            renderer.m_92883_(stack, "EU/t: " + instance.euT, (float)left, (float)(top + 24), 0xFAFAFF);
            return 32;
        }
        return 8;
    }
}

