/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.multi;

import java.util.Collection;
import java.util.Collections;
import muramasa.antimatter.Data;
import muramasa.antimatter.capability.ComponentHandler;
import muramasa.antimatter.capability.machine.HatchComponentHandler;
import muramasa.antimatter.capability.machine.MachineCoverHandler;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.cover.CoverOutput;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.structure.IComponent;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.api.gt.GTTransaction;

public class TileEntityHatch<T extends TileEntityHatch<T>>
extends TileEntityMachine<T>
implements IComponent {
    public final LazyOptional<HatchComponentHandler<T>> componentHandler = LazyOptional.of(() -> new HatchComponentHandler<TileEntityHatch>(this));

    public TileEntityHatch(final Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (type.has(MachineFlag.ENERGY)) {
            this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, (long)this.getMachineTier().getVoltage() * 66L, type.getOutputCover() == Data.COVERENERGY ? this.tier.getVoltage() : 0, type.getOutputCover() == Data.COVERDYNAMO ? this.tier.getVoltage() : 0, type.getOutputCover() == Data.COVERENERGY ? 2 : 0, type.getOutputCover() == Data.COVERDYNAMO ? 1 : 0){

                @Override
                public boolean canInput(Direction direction) {
                    ICover out = ((TileEntityHatch)this.tile).coverHandler.map(MachineCoverHandler::getOutputCover).orElse(null);
                    if (out == null) {
                        return false;
                    }
                    return out.isEqual(Data.COVERENERGY) && direction == out.side();
                }

                @Override
                protected boolean checkVoltage(GTTransaction.TransferData data) {
                    boolean flag = true;
                    if (type.getOutputCover() == Data.COVERDYNAMO) {
                        flag = data.getVoltage() <= this.getOutputVoltage();
                    } else if (type.getOutputCover() == Data.COVERENERGY) {
                        boolean bl = flag = data.getVoltage() <= this.getInputVoltage();
                    }
                    if (!flag) {
                        Utils.createExplosion(((TileEntityHatch)this.tile).m_58904_(), ((TileEntityHatch)this.tile).m_58899_(), 4.0f, Explosion.BlockInteraction.BREAK);
                    }
                    return flag;
                }

                @Override
                public boolean canOutput(Direction direction) {
                    ICover out = ((TileEntityHatch)this.tile).coverHandler.map(MachineCoverHandler::getOutputCover).orElse(null);
                    if (out == null) {
                        return false;
                    }
                    return out.isEqual(Data.COVERDYNAMO) && direction == out.side();
                }
            });
        }
    }

    public LazyOptional<HatchComponentHandler<T>> getComponentHandler() {
        return this.componentHandler;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (this.isClientSide()) {
            return;
        }
        super.onMachineEvent(event, data);
        if (event instanceof ContentEvent) {
            ((Collection)this.componentHandler.map(ComponentHandler::getControllers).orElse(Collections.emptyList())).forEach(controller -> {
                switch ((ContentEvent)event) {
                    case ITEM_INPUT_CHANGED: 
                    case ITEM_OUTPUT_CHANGED: 
                    case ITEM_CELL_CHANGED: 
                    case FLUID_INPUT_CHANGED: 
                    case FLUID_OUTPUT_CHANGED: {
                        controller.onMachineEvent(event, data);
                    }
                }
            });
        } else if (event instanceof MachineEvent) {
            ((Collection)this.componentHandler.map(ComponentHandler::getControllers).orElse(Collections.emptyList())).forEach(controller -> {
                switch ((MachineEvent)event) {
                    case ENERGY_DRAINED: 
                    case ENERGY_INPUTTED: 
                    case HEAT_INPUTTED: 
                    case HEAT_DRAINED: {
                        controller.onMachineEvent(event, data);
                        break;
                    }
                }
            });
        }
    }

    @Override
    public void onFirstTick() {
        super.onFirstTick();
        this.coverHandler.ifPresent(t -> {
            ICover cover = t.getOutputCover();
            if (!(cover instanceof CoverOutput)) {
                return;
            }
            ((CoverOutput)cover).setEjects(this.has(MachineFlag.FLUID), this.has(MachineFlag.ITEM));
        });
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation(this.getMachineType().getDomain(), "textures/gui/machine/hatch.png");
    }
}

