/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile.multi;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.capability.machine.ControllerComponentHandler;
import muramasa.antimatter.client.scene.TrackedDummyWorld;
import muramasa.antimatter.cover.CoverDynamo;
import muramasa.antimatter.cover.CoverEnergy;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.machine.BlockMultiMachine;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.structure.IComponent;
import muramasa.antimatter.structure.Structure;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.structure.StructureHandle;
import muramasa.antimatter.structure.StructureResult;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.rf.IRFNode;

public class TileEntityBasicMultiMachine<T extends TileEntityBasicMultiMachine<T>>
extends TileEntityMachine<T>
implements IComponent {
    private final Set<StructureHandle<?>> allHandlers = new ObjectOpenHashSet();
    protected StructureResult result = null;
    protected boolean shouldCheckFirstTick = true;
    private int checkingStructure = 0;
    public BlockState oldState;
    private Direction facingOverride;
    public final LazyOptional<ControllerComponentHandler> componentHandler = LazyOptional.of(() -> new ControllerComponentHandler(this));

    public TileEntityBasicMultiMachine(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.allHandlers.forEach(StructureHandle::deregister);
        StructureCache.remove(this.f_58857_, this.f_58858_);
    }

    @Nullable
    public StructureResult getResult() {
        return this.result;
    }

    public int maxShares() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onFirstTick() {
        this.allHandlers.forEach(StructureHandle::register);
        Structure s = this.getMachineType().getStructure(this.getMachineTier());
        if (s == null) {
            super.onFirstTick();
            return;
        }
        if (!this.isStructureValid() && this.shouldCheckFirstTick) {
            this.checkStructure();
        }
        super.onFirstTick();
    }

    @Override
    public Direction getFacing() {
        return this.facingOverride != null ? this.facingOverride : super.getFacing();
    }

    public boolean checkStructure() {
        Structure structure = this.getMachineType().getStructure(this.getMachineTier());
        if (structure == null) {
            return false;
        }
        ++this.checkingStructure;
        StructureResult result = structure.evaluate(this);
        if (result.evaluate()) {
            if (this.f_58857_ instanceof TrackedDummyWorld) {
                this.result = result;
                StructureCache.add(this.f_58857_, this.f_58858_, this.getMachineType().getStructure(this.getMachineTier()).allPositions(this));
                StructureCache.validate(this.f_58857_, this.f_58858_, result.positions, this.maxShares());
                return true;
            }
            if (StructureCache.validate(this.f_58857_, this.f_58858_, result.positions, this.maxShares())) {
                this.result = result;
                result.build(this, result);
                if (this.isServerSide()) {
                    if (this.onStructureFormed()) {
                        this.afterStructureFormed();
                        if (this.machineState != MachineState.ACTIVE && this.machineState != MachineState.DISABLED) {
                            this.setMachineState(MachineState.IDLE);
                        }
                        this.recipeHandler.ifPresent(t -> t.onMultiBlockStateChange(true, (Boolean)AntimatterConfig.COMMON_CONFIG.INPUT_RESET_MULTIBLOCK.get()));
                        this.sidedSync(true);
                        --this.checkingStructure;
                        return true;
                    }
                    this.invalidateStructure();
                    --this.checkingStructure;
                    return false;
                }
                if (this.onStructureFormed()) {
                    this.result.components.forEach((k, v) -> v.forEach(c -> Utils.markTileForRenderUpdate(c.getTile())));
                    this.sidedSync(true);
                    --this.checkingStructure;
                    return true;
                }
                this.invalidateStructure();
                --this.checkingStructure;
                return false;
            }
        }
        this.invalidateStructure();
        --this.checkingStructure;
        return false;
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.result != null) {
            this.result.tick(this);
        }
    }

    public <T> LazyOptional<T> getCapabilityFromFake(Class<T> cap, BlockPos pos, Direction side, ICover coverPresent) {
        if (cap == IItemHandler.class && this.itemHandler.isPresent()) {
            return this.itemHandler.side(side).cast();
        }
        if (cap == IFluidHandler.class && this.fluidHandler.isPresent()) {
            return this.fluidHandler.side(side).cast();
        }
        if (cap == IEnergyHandler.class && this.energyHandler.isPresent() && (coverPresent instanceof CoverDynamo || coverPresent instanceof CoverEnergy)) {
            return this.energyHandler.side(side).cast();
        }
        if (cap == IRFNode.class && this.rfHandler.isPresent() && (coverPresent instanceof CoverDynamo || coverPresent instanceof CoverEnergy)) {
            return this.rfHandler.side(side).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onBlockUpdate(BlockPos pos) {
        if (this.checkingStructure > 0) {
            return;
        }
        if (this.result != null) {
            if (!this.getMachineType().getStructure(this.getMachineTier()).evaluatePosition(this.result, this, pos)) {
                this.invalidateStructure();
            }
        } else {
            this.checkStructure();
        }
    }

    @Override
    public void setMachineState(MachineState newState) {
        if (this.f_58859_) {
            return;
        }
        super.setMachineState(newState);
        if (this.result != null) {
            this.result.updateState(this, this.result);
        }
    }

    @Override
    protected void setMachineStateBlockState(MachineState newState) {
        BlockState state = this.m_58900_();
        if (newState == MachineState.ACTIVE || newState == MachineState.IDLE || newState == MachineState.INVALID_STRUCTURE) {
            state = (BlockState)state.m_61124_(BlockMultiMachine.MACHINE_STATE, (Comparable)((Object)newState));
            this.m_58904_().m_46597_(this.m_58899_(), state);
        }
    }

    public void m_155250_(BlockState p_155251_) {
        BlockState old = this.m_58900_();
        super.m_155250_(p_155251_);
        BlockState newState = this.m_58900_();
        if (!old.equals(newState)) {
            if (this.result != null) {
                StructureCache.invalidate(this.m_58904_(), this.m_58899_(), this.result.positions);
            }
            StructureCache.remove(this.f_58857_, this.m_58899_());
            this.oldState = old;
            this.facingOverride = Utils.dirFromState(this.oldState);
            StructureCache.add(this.f_58857_, this.m_58899_(), this.getMachineType().getStructure(this.getMachineTier()).allPositions(this));
            this.checkStructure();
            this.oldState = null;
            this.facingOverride = null;
        }
    }

    @Override
    public void onMachineStop() {
        super.onMachineStop();
    }

    protected void invalidateStructure() {
        if (this.m_58904_() instanceof TrackedDummyWorld) {
            return;
        }
        if (this.result == null) {
            if (this.isServerSide() && this.getMachineState() != this.getDefaultMachineState()) {
                this.resetMachine();
            }
            return;
        }
        ++this.checkingStructure;
        StructureCache.invalidate(this.m_58904_(), this.m_58899_(), this.result.positions);
        if (this.isServerSide()) {
            this.onStructureInvalidated();
            this.result.remove(this, this.result);
            this.result = null;
            this.recipeHandler.ifPresent(t -> t.onMultiBlockStateChange(false, (Boolean)AntimatterConfig.COMMON_CONFIG.INPUT_RESET_MULTIBLOCK.get()));
        } else {
            this.result.components.forEach((k, v) -> v.forEach(c -> Utils.markTileForRenderUpdate(c.getTile())));
            this.result = null;
        }
        --this.checkingStructure;
    }

    public List<IComponentHandler> getComponents(IAntimatterObject object) {
        return this.getComponents(object.getId());
    }

    public List<IComponentHandler> getComponents(String id) {
        if (this.result != null) {
            List<IComponentHandler> list = (List<IComponentHandler>)this.result.components.get((Object)id);
            return list != null ? list : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public List<BlockState> getStates(String id) {
        if (this.result != null) {
            List<BlockState> list = (List<BlockState>)this.result.states.get((Object)id);
            return list != null ? list : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean isStructureValid() {
        return StructureCache.has(this.f_58857_, this.f_58858_);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Structure struc = this.getMachineType().getStructure(this.getMachineTier());
        if (struc != null) {
            StructureCache.add(this.f_58857_, this.f_58858_, struc.allPositions(this));
        }
    }

    public boolean onStructureFormed() {
        return true;
    }

    public void afterStructureFormed() {
    }

    public void onStructureInvalidated() {
    }

    @Override
    public MachineState getDefaultMachineState() {
        if (this.result == null) {
            return MachineState.INVALID_STRUCTURE;
        }
        return MachineState.IDLE;
    }

    public LazyOptional<ControllerComponentHandler> getComponentHandler() {
        return this.componentHandler;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.getMachineState() == MachineState.INVALID_STRUCTURE) {
            this.shouldCheckFirstTick = false;
        }
    }

    public void addStructureHandle(StructureHandle<?> handle) {
        this.allHandlers.add(handle);
    }
}

