/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.integration.jeirei.renderer.IInfoRenderer;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.machine.types.TankMachine;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityTank<T extends TileEntityMachine<T>>
extends TileEntityMachine<T>
implements IInfoRenderer<TankMachine.TankRenderWidget> {
    public TileEntityTank(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new MachineFluidHandler<T>(this){

            @Override
            @Nullable
            public FluidTanks getOutputTanks() {
                return super.getInputTanks();
            }

            @Override
            protected FluidTank getTank(int tank) {
                return this.getInputTanks().getTank(tank);
            }

            @Override
            public FluidTanks getTanks(int tank) {
                return this.getInputTanks();
            }
        });
    }

    @Override
    public int drawInfo(TankMachine.TankRenderWidget instance, PoseStack stack, Font renderer, int left, int top) {
        renderer.m_92883_(stack, instance.stack.getDisplayName().getString(), (float)(left += 55), (float)(top += 24), 0xFAFAFF);
        StringBuilder fluidAmount = new StringBuilder().append(instance.stack.getAmount());
        if (AntimatterPlatformUtils.isFabric()) {
            fluidAmount.append(" ").append(this.intToSuperScript((int)(instance.stack.getRealAmount() % 81L))).append("/\u2088\u2081");
        }
        renderer.m_92883_(stack, fluidAmount.toString() + " mb", (float)left, (float)(top + 8), 0xFAFAFF);
        return 16;
    }

    private String intToSuperScript(int i) {
        String intString = String.valueOf(i);
        StringBuilder builder = new StringBuilder();
        for (char c : intString.toCharArray()) {
            builder.append(this.charToSuperScript(c));
        }
        return builder.toString();
    }

    private String charToSuperScript(char c) {
        return switch (c) {
            case '0' -> "\u2070";
            case '1' -> "\u00b9";
            case '2' -> "\u00b2";
            case '3' -> "\u00b3";
            case '4' -> "\u2074";
            case '5' -> "\u2075";
            case '6' -> "\u2076";
            case '7' -> "\u2077";
            case '8' -> "\u2078";
            case '9' -> "\u2079";
            default -> String.valueOf(c);
        };
    }
}

