/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.tile;

import java.util.List;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;

public abstract class TileEntityStorage<T extends TileEntityStorage<T>>
extends TileEntityMachine<T> {
    public TileEntityStorage(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyHandler.set(() -> new MachineEnergyHandler<T>(this, 0L, (long)this.getMachineTier().getVoltage() * (long)this.itemHandler.map(m -> m.getChargeHandler().getSlots()).orElse(1).intValue(), this.getMachineTier().getVoltage(), this.getMachineTier().getVoltage(), 1, 0){

            @Override
            public boolean canOutput(Direction direction) {
                Direction dir = ((TileEntityStorage)this.tile).getFacing();
                return dir != null && dir.m_122411_() == direction.m_122411_();
            }

            @Override
            public void onMachineEvent(IMachineEvent event, Object ... data) {
                super.onMachineEvent(event, data);
            }

            @Override
            public void onUpdate() {
                super.onUpdate();
                long energyToInsert = this.cachedItems.size() > 0 && this.energy % (long)this.cachedItems.size() == 0L ? this.energy / (long)this.cachedItems.size() : this.energy;
                this.cachedItems.forEach(h -> {
                    long toAdd = Math.min(this.energy, Math.min(energyToInsert, ((IEnergyHandlerItem)h.right()).getCapacity() - ((IEnergyHandlerItem)h.right()).getEnergy()));
                    if (toAdd > 0L && Utils.addEnergy((IEnergyHandler)h.right(), toAdd)) {
                        ((ItemStack)h.left()).m_41751_(((IEnergyHandlerItem)h.right()).getContainer().getTag());
                        this.energy -= toAdd;
                    }
                });
            }
        });
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    @Override
    public List<String> getInfo() {
        List<String> info = super.getInfo();
        this.energyHandler.ifPresent(h -> {
            info.add("Amperage In: " + h.availableAmpsInput());
            info.add("Amperage Out: " + h.availableAmpsOutput());
        });
        return info;
    }
}

